/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.workermanager.keepalive;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.eclipse.smila.taskmanager.Task;

public class DelayedTask
implements Delayed {
    private final Task _task;
    private final long _delay;

    public DelayedTask(Task task, long delay, TimeUnit timeUnit) {
        this._task = task;
        this._delay = System.nanoTime() + TimeUnit.NANOSECONDS.convert(delay, timeUnit);
    }

    @Override
    public int compareTo(Delayed arg0) {
        return Long.valueOf(this.getDelay(TimeUnit.NANOSECONDS)).compareTo(arg0.getDelay(TimeUnit.NANOSECONDS));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DelayedTask) {
            return this.getTask().getTaskId().equals(((DelayedTask)obj).getTask().getTaskId());
        }
        return false;
    }

    public int hashCode() {
        return this.getTask().getTaskId().hashCode();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this._delay - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public Task getTask() {
        return this._task;
    }
}

