/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.helpers;

import java.io.File;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.Main;
import org.eclipse.smila.management.jmx.client.config.JmxClientConfigType;
import org.eclipse.smila.management.jmx.client.exceptions.ConfigurationLoadException;

public final class ConfigLoader {
    private ConfigLoader() {
    }

    public static JmxClientConfigType load(InputStream is) throws ConfigurationLoadException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.eclipse.smila.management.jmx.client.config");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File("schemas/jmxclient.xsd"));
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler(ConfigLoader.createValidationEventHandler());
            Object result = unmarshaller.unmarshal(is);
            if (result != null && result instanceof JAXBElement) {
                result = ((JAXBElement)result).getValue();
            }
            JmxClientConfigType jmxClientConfigType = (JmxClientConfigType)result;
            return jmxClientConfigType;
        }
        catch (Throwable e) {
            throw new ConfigurationLoadException("Unable to load configuration", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public static ValidationEventHandler createValidationEventHandler() {
        return new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent ve) {
                Log log = LogFactory.getLog(Main.class);
                if (ve.getSeverity() != 0) {
                    ValidationEventLocator vel = ve.getLocator();
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Line:Col[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "]:" + ve.getMessage()));
                    }
                    return false;
                }
                return true;
            }
        };
    }
}

