/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementCategory;
import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.management.internal.ManagementTreeNodeImpl;

public class ManagementAgentLocationImpl
extends ManagementTreeNodeImpl
implements ManagementAgentLocation {
    private final ManagementCategory _category;
    private final String _name;

    public ManagementAgentLocationImpl(ManagementCategory category, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Location name cannot be null!");
        }
        Pattern pattern = Pattern.compile("[^\\w]", 2);
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            throw new IllegalArgumentException("Name should contains only words symbols,  digits or underscore");
        }
        this._category = category;
        this._name = name;
        this._path = this._category == null ? this._name : String.format("%s/%s", this._category.getPath(), this._name);
    }

    @Override
    public ManagementCategory getCategory() {
        return this._category;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void register(ManagementAgent agent) {
        ManagementRegistration.INSTANCE.registerAgent(this, agent);
    }

    @Override
    public void unregister(ManagementAgent agent) {
        ManagementRegistration.INSTANCE.unregisterAgent(this);
    }
}

