/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.solr.admin.SolrAdministration;
import org.eclipse.smila.solr.admin.SolrAdministrationException;
import org.eclipse.smila.solr.server.SolrServers;

public abstract class AbstractSolrAdministration
implements SolrAdministration {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final SolrServers _servers;
    private final Map<String, List<String>> _cachedFieldNames = new HashMap<String, List<String>>();
    private final Map<String, Map<String, Any.ValueType>> _cachedFieldNamesAndTypes = new HashMap<String, Map<String, Any.ValueType>>();

    public AbstractSolrAdministration(SolrServers servers) {
        this._servers = servers;
    }

    @Override
    public AnyMap status() throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.STATUS.toString()));
        return this.handle(params);
    }

    @Override
    public AnyMap status(String core) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.STATUS.toString()));
        params.put("core", this.convertStringToArray(core));
        return this.handle(params);
    }

    @Override
    public AnyMap create(String name, String instanceDir) throws SolrAdministrationException {
        return this.create(name, instanceDir, null);
    }

    @Override
    public AnyMap create(String name, String instanceDir, Map<String, String[]> otherParams) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.CREATE.toString()));
        params.put("name", this.convertStringToArray(name));
        params.put("instanceDir", this.convertStringToArray(instanceDir));
        if (MapUtils.isNotEmpty(otherParams)) {
            params.putAll(otherParams);
        }
        return this.handle(params);
    }

    @Override
    public AnyMap reload(String core) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.RELOAD.toString()));
        params.put("core", this.convertStringToArray(core));
        return this.handle(params);
    }

    @Override
    public AnyMap rename(String core, String other) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.RENAME.toString()));
        params.put("core", this.convertStringToArray(core));
        params.put("other", this.convertStringToArray(other));
        return this.handle(params);
    }

    @Override
    public AnyMap swap(String core, String other) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.SWAP.toString()));
        params.put("core", this.convertStringToArray(core));
        params.put("other", this.convertStringToArray(other));
        return this.handle(params);
    }

    @Override
    public AnyMap unload(String core) throws SolrAdministrationException {
        return this.unload(core, false);
    }

    @Override
    public AnyMap unload(String core, boolean deleteIndex) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.UNLOAD.toString()));
        params.put("core", this.convertStringToArray(core));
        params.put("deleteIndex", this.convertStringToArray(String.valueOf(deleteIndex)));
        return this.handle(params);
    }

    @Override
    public AnyMap load(String core) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.LOAD.toString()));
        params.put("core", this.convertStringToArray(core));
        return this.handle(params);
    }

    @Override
    public AnyMap mergeIndexes(String core, String ... srcCore) throws SolrAdministrationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("action", this.convertStringToArray(CoreAdminParams.CoreAdminAction.MERGEINDEXES.toString()));
        params.put("core", this.convertStringToArray(core));
        params.put("srcCore", srcCore);
        return this.handle(params);
    }

    public String[] convertStringToArray(String string) {
        return new String[]{string};
    }

    private AnyMap handle(Map<String, String[]> params) throws SolrAdministrationException {
        this._log.debug((Object)("Handle admin request with following parameters: " + this.convertMapToString(params)));
        NamedList<Object> response = this.handleRequest(params);
        return this.handleResponse(response);
    }

    abstract NamedList<Object> handleRequest(Map<String, String[]> var1) throws SolrAdministrationException;

    private AnyMap handleResponse(NamedList<Object> response) {
        if (response == null) {
            return null;
        }
        AnyMap map = DataFactory.DEFAULT.createAnyMap();
        return this.convertNamedListToAnyMap(response, map);
    }

    AnyMap convertNamedListToAnyMap(NamedList<Object> list, AnyMap map) {
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof NamedList) {
                AnyMap subMap = map.getMap(key, true);
                this.convertNamedListToAnyMap((NamedList<Object>)((NamedList)obj), subMap);
                continue;
            }
            try {
                Value value = DataFactory.DEFAULT.autoConvertValue(obj);
                map.put(key, (Any)value);
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
        return map;
    }

    protected String convertMapToString(Map<String, String[]> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            sb.append(key);
            sb.append("=");
            String[] values = entry.getValue();
            int i = 0;
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                sb.append(value);
                if (values.length > ++i) {
                    sb.append(",");
                }
                ++n2;
            }
            sb.append(";");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFieldNames(String coreName) throws Exception {
        List<String> fieldNames = this._cachedFieldNames.get(coreName);
        if (fieldNames == null) {
            Map<String, List<String>> map = this._cachedFieldNames;
            synchronized (map) {
                fieldNames = this.readFieldNames(coreName);
                this._cachedFieldNames.put(coreName, fieldNames);
            }
        }
        return fieldNames;
    }

    protected abstract List<String> readFieldNames(String var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Any.ValueType> getFieldNamesAndTypes(String coreName) throws Exception {
        Map<String, Any.ValueType> fieldNamesAndTypes = this._cachedFieldNamesAndTypes.get(coreName);
        if (fieldNamesAndTypes == null) {
            Map<String, Map<String, Any.ValueType>> map = this._cachedFieldNamesAndTypes;
            synchronized (map) {
                fieldNamesAndTypes = this.readFieldNamesAndTypes(coreName);
                this._cachedFieldNamesAndTypes.put(coreName, fieldNamesAndTypes);
            }
        }
        return fieldNamesAndTypes;
    }

    protected abstract Map<String, Any.ValueType> readFieldNamesAndTypes(String var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCoreCaches() {
        Map<String, List<String>> map = this._cachedFieldNames;
        synchronized (map) {
            this._cachedFieldNames.clear();
            this._cachedFieldNamesAndTypes.clear();
            this._servers.removeAllServers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCoreCache(String coreName) {
        Map<String, List<String>> map = this._cachedFieldNames;
        synchronized (map) {
            this._cachedFieldNames.remove(coreName);
            this._cachedFieldNamesAndTypes.remove(coreName);
            this._servers.removeSolrServer(coreName);
        }
    }

    @Override
    public AnyMap optimize(String coreName) throws SolrAdministrationException {
        try {
            SolrServer server = this._servers.getSolrServer(coreName);
            UpdateResponse response = server.optimize();
            return this.handleResponse((NamedList<Object>)response.getResponse());
        }
        catch (Exception exception) {
            throw new SolrAdministrationException("Error while optimize core with name: " + coreName, exception);
        }
    }

    @Override
    public AnyMap ping(String coreName) throws SolrAdministrationException {
        try {
            SolrServer server = this._servers.getSolrServer(coreName);
            SolrPingResponse response = server.ping();
            return this.handleResponse((NamedList<Object>)response.getResponse());
        }
        catch (Exception exception) {
            throw new SolrAdministrationException("Error while ping core with name: " + coreName, exception);
        }
    }

    protected Any.ValueType resolveSolrTypeClassName(String solrTypeClassName) {
        if (solrTypeClassName.contains("LongField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeClassName.contains("IntField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeClassName.contains("ShortField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeClassName.contains("FloatField")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeClassName.contains("DoubleField")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeClassName.contains("DateField")) {
            return Any.ValueType.DATETIME;
        }
        return Any.ValueType.STRING;
    }
}

