/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.util.NamedList;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.solr.admin.AbstractSolrAdministration;
import org.eclipse.smila.solr.admin.SolrAdministrationException;
import org.eclipse.smila.solr.server.SolrServers;
import org.eclipse.smila.solr.util.SolrProperties;

public class RemoteSolrAdministration
extends AbstractSolrAdministration {
    private final HttpClient _httpClient = new HttpClient();
    private final SolrProperties _properties;

    public RemoteSolrAdministration(SolrServers servers, SolrProperties properties) {
        super(servers);
        this._properties = properties;
    }

    @Override
    NamedList<Object> handleRequest(Map<String, String[]> parameter) throws SolrAdministrationException {
        try {
            String uri = this._properties.getServerUrl();
            uri = String.valueOf(uri) + "/admin/cores";
            PostMethod method = new PostMethod(uri);
            for (Map.Entry<String, String[]> entry : parameter.entrySet()) {
                method.addParameter(entry.getKey(), entry.getValue()[0]);
            }
            int status = this._httpClient.executeMethod((HttpMethod)method);
            if (status != 200) {
                String body = method.getResponseBodyAsString();
                throw new HttpException(status, body);
            }
            InputStream response = method.getResponseBodyAsStream();
            XMLResponseParser parser = new XMLResponseParser();
            return parser.processResponse(response, "UTF-8");
        }
        catch (Exception exception) {
            String debugParameter = this.convertMapToString(parameter);
            throw new SolrAdministrationException("Error while handle request on remote server with following params: " + debugParameter, exception);
        }
    }

    @Override
    public List<String> getCoreNames() throws Exception {
        NamedList cores;
        ArrayList<String> coreNames = new ArrayList<String>();
        SolrServer adminServer = this._servers.getAdminServer();
        CoreAdminResponse status = CoreAdminRequest.getStatus(null, (SolrServer)adminServer);
        NamedList response = status.getResponse();
        if (response != null && (cores = (NamedList)response.get("status")) != null) {
            for (Map.Entry entry : cores) {
                coreNames.add((String)entry.getKey());
            }
        }
        return coreNames;
    }

    @Override
    protected List<String> readFieldNames(String coreName) throws SolrServerException, IOException {
        SolrServer server = this._servers.getSolrServer(coreName);
        LukeRequest request = new LukeRequest();
        request.setShowSchema(true);
        request.setNumTerms(0);
        LukeResponse response = request.process(server);
        Map fields = response.getFieldInfo();
        return new ArrayList<String>(fields.keySet());
    }

    @Override
    protected Map<String, Any.ValueType> readFieldNamesAndTypes(String coreName) throws SolrServerException, IOException {
        SolrServer server = this._servers.getSolrServer(coreName);
        LukeRequest request = new LukeRequest();
        request.setShowSchema(true);
        request.setNumTerms(0);
        LukeResponse response = request.process(server);
        Map fieldInfos = response.getFieldInfo();
        Map fieldTypeInfos = response.getFieldTypeInfo();
        HashMap<String, Any.ValueType> result = new HashMap<String, Any.ValueType>();
        for (LukeResponse.FieldInfo fieldInfo : fieldInfos.values()) {
            LukeResponse.FieldTypeInfo fieldTypeInfo = (LukeResponse.FieldTypeInfo)fieldTypeInfos.get(fieldInfo.getType());
            Any.ValueType valueType = this.resolveSolrTypeClassName(fieldTypeInfo.getClassName());
            result.put(fieldInfo.getName(), valueType);
        }
        return result;
    }
}

