/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;

public class SolrQueryParameterAccessor
extends QueryParameterAccessor {
    public SolrQueryParameterAccessor(Blackboard blackboard, String queryRecordId) throws BlackboardAccessException {
        super(blackboard, queryRecordId);
    }

    public SolrQueryParameterAccessor(Blackboard blackboard, AnyMap configuration, String queryRecordId) throws BlackboardAccessException {
        super(blackboard, configuration, queryRecordId);
    }

    public String getRequestHandler() {
        return this.getSolrQueryParams().getStringValue("qt");
    }

    public AnyMap getTerms() {
        return this.getSolrQueryParams().getMap("terms");
    }

    public AnySeq getFilterQuery() {
        return this.getSolrQueryParams().getSeq("fq");
    }

    public AnySeq getShards() {
        return this.getSolrQueryParams().getSeq("shards");
    }

    public AnyMap getSpellcheck() {
        return this.getSolrQueryParams().getMap("spellcheck");
    }

    public AnyMap getSolrQueryParams() {
        Any _solrQueryParams = this.getParameterAny("_solr.query");
        return _solrQueryParams == null ? AnyUtil.EMPTY_MAP : _solrQueryParams.asMap();
    }

    public AnyMap getMoreLikeThis() {
        return this.getSolrQueryParams().getMap("moreLikeThis");
    }

    public AnyMap getFilterGroups() {
        return this.getSolrQueryParams().getMap("filterGroups");
    }

    public AnyMap getFilterLocalParams() {
        return this.getFilterLocalParams("localParams", false);
    }

    public AnyMap getFilterLocalParams(String filterGroup, boolean create) {
        AnyMap filterGroups = this.getSolrQueryParams().getMap("filterGroups", create);
        if (filterGroups == null) {
            return null;
        }
        AnyMap filterGroupConfig = filterGroups.getMap(filterGroup, create);
        if (filterGroupConfig == null) {
            return null;
        }
        return filterGroupConfig.getMap("localParams", create);
    }
}

