/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class SetValuePipelet
implements Pipelet {
    private static final String PARAM_ATTRIBUTE = "outputAttribute";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_OVERWRITE = "overwrite";
    private AnyMap _config;
    private final Log _log = LogFactory.getLog(this.getClass());

    public void configure(AnyMap configuration) throws ProcessingException {
        this._config = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            paramAccessor.setCurrentRecord(id);
            String outputAttribute = paramAccessor.getParameter(PARAM_ATTRIBUTE, null);
            Any value = paramAccessor.getParameterAny(PARAM_VALUE);
            if (value != null && outputAttribute != null) {
                try {
                    Any oldValue = blackboard.getMetadata(id).put(outputAttribute, value);
                    if (oldValue != null && !paramAccessor.getBooleanParameter(PARAM_OVERWRITE, Boolean.FALSE).booleanValue()) {
                        blackboard.getMetadata(id).put(outputAttribute, oldValue);
                    }
                    resultCollector.addResult(id);
                }
                catch (Exception ex) {
                    resultCollector.addFailedResult(id, ex);
                }
            }
            ++n2;
        }
        return resultCollector.getResultIds();
    }
}

