/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.impl.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.http.client.BulkResponse;

public class BulkResponseImpl
implements BulkResponse {
    private BufferedReader _lineReader;
    private String _jsonLine;
    private final IpcAnyReader _jsonReader = new IpcAnyReader();

    public BulkResponseImpl(InputStream responseStream) throws IOException {
        this._lineReader = new BufferedReader(new InputStreamReader(responseStream, "UTF-8"));
    }

    @Override
    public Iterator<AnyMap> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._jsonLine == null && this._lineReader != null) {
            try {
                try {
                    this._jsonLine = this._lineReader.readLine();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to read another JSON line from bulk", ex);
                }
            }
            finally {
                if (this._jsonLine == null) {
                    this.close();
                }
            }
        }
        return this._jsonLine != null;
    }

    @Override
    public AnyMap next() {
        if (this.hasNext()) {
            try {
                AnyMap nextObject = this._jsonReader.readJsonObject(this._jsonLine).asMap();
                this._jsonLine = null;
                return nextObject;
            }
            catch (Exception ex) {
                this.close();
                throw new RuntimeException("Failed to parse JSON line from bulk", ex);
            }
        }
        throw new NoSuchElementException("No more objects available in JSON bulk.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this._lineReader != null) {
            try {
                this._lineReader.close();
            }
            catch (Exception exception) {}
            this._lineReader = null;
            this._jsonLine = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

