/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.impl.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.params.HttpParams;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.client.Attachments;
import org.eclipse.smila.http.client.BulkResponse;
import org.eclipse.smila.http.client.HttpMethod;
import org.eclipse.smila.http.client.RestClient;
import org.eclipse.smila.http.client.RestException;
import org.eclipse.smila.http.client.attachments.RecordAttachments;
import org.eclipse.smila.http.client.impl.base.HttpRequestExecutor;
import org.eclipse.smila.http.client.impl.base.HttpRequestFactory;
import org.eclipse.smila.http.client.impl.base.HttpResultHandler;
import org.eclipse.smila.http.client.util.HttpClientUtil;

public class RestClientBase
implements RestClient {
    protected static final String DEFAULT_HOSTANDPORT = "http://localhost:8080";
    private final HttpClient _client;
    private final ClientConnectionManager _connectionManager;
    private HttpRequestFactory _requestFactory;
    private HttpRequestExecutor _requestExecutor;
    private HttpResultHandler _resultHandler;
    private final Log _log = LogFactory.getLog(this.getClass());

    public RestClientBase(ClientConnectionManager connectionManager, HttpRequestFactory requestFactory, HttpRequestExecutor requestExecutor, HttpResultHandler resultHandler) {
        this._connectionManager = connectionManager;
        this._requestFactory = requestFactory;
        this._requestExecutor = requestExecutor;
        this._resultHandler = resultHandler;
        this._client = HttpClientUtil.createInstance(this._connectionManager);
    }

    public void setRequestFactory(HttpRequestFactory requestFactory) {
        this._requestFactory = requestFactory;
    }

    public void setRequestExecutor(HttpRequestExecutor requestExecutor) {
        this._requestExecutor = requestExecutor;
    }

    public void setResultHandler(HttpResultHandler resultHandler) {
        this._resultHandler = resultHandler;
    }

    @Override
    public void setClientParameter(String name, Object value) {
        this._client.getParams().setParameter(name, value);
    }

    @Override
    public void shutdown() {
        this._connectionManager.shutdown();
    }

    @Override
    public String getHostAndPort() {
        return this._requestExecutor.getHostAndPort();
    }

    @Override
    public AnyMap get(String resource) throws RestException, IOException {
        return this.invokeAsMap(HttpMethod.GET, resource, null, null, null);
    }

    @Override
    public AnyMap get(String resource, AnyMap parameters) throws RestException, IOException {
        return this.invokeAsMap(HttpMethod.GET, this.buildPathAndQuery(resource, parameters), null, null, null);
    }

    @Override
    public BulkResponse getBulk(String resource, HttpParams methodParams) throws IOException, RestException {
        String url = this.createUrl(resource);
        HttpUriRequest request = this._requestFactory.getHttpMethod(HttpMethod.GET, url, methodParams);
        try {
            HttpResponse response = this._requestExecutor.execute(this._client, request);
            InputStream content = this._resultHandler.processHttpResponse(request, response);
            return this._resultHandler.handleJsonBulkResult(content);
        }
        catch (ConnectException e) {
            request.abort();
            throw new ConnectException(this.createConnectErrorMessage(url, e));
        }
    }

    @Override
    public AnyMap post(String resource) throws RestException, IOException {
        return this.post(resource, null, null);
    }

    @Override
    public AnyMap post(String resource, AnyMap parameters) throws RestException, IOException {
        return this.post(resource, parameters, null);
    }

    @Override
    public AnyMap post(String resource, AnyMap parameters, Attachments attachments) throws RestException, IOException {
        return this.invokeAsMap(HttpMethod.POST, resource, parameters, attachments, null);
    }

    @Override
    public AnyMap post(String resource, Record record) throws RestException, IOException {
        RecordAttachments attachments = null;
        if (record.hasAttachments()) {
            attachments = new RecordAttachments(record);
        }
        return this.post(resource, record.getMetadata(), attachments);
    }

    @Override
    public AnyMap post(String resource, String parameters, String encoding, String contentType) throws RestException, IOException {
        return this.asMap(this.doRequest(HttpMethod.POST, resource, (HttpEntity)new StringEntity(parameters, contentType, encoding), null));
    }

    @Override
    public AnyMap put(String resource, AnyMap parameters) throws RestException, IOException {
        return this.invokeAsMap(HttpMethod.PUT, resource, parameters, null, null);
    }

    @Override
    public AnyMap put(String resource, Record record) throws RestException, IOException {
        return this.put(resource, record.getMetadata());
    }

    @Override
    public AnyMap delete(String resource) throws RestException, IOException {
        return this.invokeAsMap(HttpMethod.DELETE, resource, null, null, null);
    }

    @Override
    public AnyMap delete(String resource, AnyMap parameters) throws RestException, IOException {
        return this.invokeAsMap(HttpMethod.DELETE, this.buildPathAndQuery(resource, parameters), null, null, null);
    }

    @Override
    public Any invoke(HttpMethod method, String resource, InputStream inputStream, HttpParams params) throws RestException, IOException {
        HttpEntity entity = this._requestFactory.createJsonEntity(inputStream);
        return this.doRequest(method, resource, entity, params);
    }

    @Override
    public Any invoke(HttpMethod method, String resource, InputStream inputStream, String contentType, HttpParams params) throws RestException, IOException {
        HttpEntity entity = this._requestFactory.createEntity(inputStream, contentType);
        return this.doRequest(method, resource, entity, params);
    }

    @Override
    public Any invoke(HttpMethod method, String resource, AnyMap parameters, Attachments attachments, HttpParams httpParams) throws RestException, IOException {
        HttpEntity requestEntity = this._requestFactory.createHttpEntity((Any)parameters, attachments);
        return this.doRequest(method, resource, requestEntity, null);
    }

    @Override
    public Any invoke(HttpMethod method, String resource, AnySeq parameters, Attachments attachments, HttpParams httpParams) throws RestException, IOException {
        HttpEntity requestEntity = this._requestFactory.createHttpEntity((Any)parameters, attachments);
        return this.doRequest(method, resource, requestEntity, null);
    }

    protected AnyMap invokeAsMap(HttpMethod method, String resource, AnyMap parameters, Attachments attachments, HttpParams httpParams) throws RestException, IOException {
        return this.asMap(this.invoke(method, resource, parameters, attachments, httpParams));
    }

    protected AnyMap asMap(Any result) throws RestException, IOException {
        if (result == null) {
            return null;
        }
        if (result.isMap()) {
            return result.asMap();
        }
        AnyMap resultAsMap = result.getFactory().createAnyMap();
        resultAsMap.put("result", result);
        return resultAsMap;
    }

    protected Any doRequest(HttpMethod method, String resource, HttpEntity requestEntity, HttpParams params) throws RestException, IOException {
        String url = this.createUrl(resource);
        HttpUriRequest request = this._requestFactory.getHttpMethod(method, url, params);
        try {
            if (requestEntity != null) {
                if (request instanceof HttpEntityEnclosingRequest) {
                    ((HttpEntityEnclosingRequest)request).setEntity(requestEntity);
                } else {
                    this._log.warn((Object)("Method " + (Object)((Object)method) + " does not support sending a request body, input is ignored."));
                }
            }
            HttpResponse response = this._requestExecutor.execute(this._client, request);
            InputStream content = this._resultHandler.processHttpResponse(request, response);
            return this._resultHandler.handleJsonResult(content);
        }
        catch (ConnectException e) {
            request.abort();
            throw new ConnectException(this.createConnectErrorMessage(url, e));
        }
    }

    protected String createUrl(String resource) {
        if (resource.startsWith("/")) {
            return String.valueOf(this._requestExecutor.getHostAndPort()) + resource;
        }
        return String.valueOf(this._requestExecutor.getHostAndPort()) + "/" + resource;
    }

    protected String createConnectErrorMessage(String url, ConnectException e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = "";
        }
        msg = String.valueOf(msg) + " on " + url;
        return msg;
    }

    protected String buildPathAndQuery(String resource, AnyMap parameters) {
        if (parameters.isEmpty()) {
            return resource;
        }
        StringBuilder query = new StringBuilder("?");
        for (Map.Entry entry : parameters.entrySet()) {
            if (!((Any)entry.getValue()).isValue()) continue;
            try {
                String name = URLEncoder.encode((String)entry.getKey(), "UTF-8");
                String value = URLEncoder.encode(((Any)entry.getValue()).asValue().asString(), "UTF-8");
                if (query.length() > 1) {
                    query.append("&");
                }
                query.append(name).append("=").append(value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return String.valueOf(resource) + query.toString();
    }
}

