/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.SSLException;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

final class ClientThread
extends Thread {
    NetworkServerControlImpl parent;
    ServerSocket serverSocket;
    private int timeSlice;
    private int connNum;

    ClientThread(NetworkServerControlImpl nsi, ServerSocket ss) {
        NetworkServerControlImpl.setUniqueThreadName(this, "NetworkServerThread");
        this.parent = nsi;
        this.serverSocket = ss;
        this.timeSlice = nsi.getTimeSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket clientSocket = null;
        while (true) {
            try {
                try {
                    try {
                        while (true) {
                            clientSocket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return ClientThread.this.serverSocket.accept();
                                }
                            });
                            if (this.parent.getShutdown()) {
                                clientSocket.close();
                                return;
                            }
                            clientSocket.setKeepAlive(this.parent.getKeepAlive());
                            if (this.timeSlice > 0) {
                                clientSocket.setSoTimeout(this.timeSlice);
                            }
                            this.parent.addSession(clientSocket);
                        }
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (SSLException ssle) {
                    this.parent.consoleExceptionPrintTrace(ssle);
                    this.parent.directShutdownInternal();
                    return;
                }
                catch (IOException ioe) {
                    Object object = this.parent.getShutdownSync();
                    synchronized (object) {
                        if (!this.parent.getShutdown()) {
                            this.parent.consoleExceptionPrintTrace(ioe);
                            if (clientSocket != null) {
                                clientSocket.close();
                            }
                        }
                        return;
                    }
                }
            }
            catch (Exception e) {
                this.parent.consoleExceptionPrintTrace(e);
                try {
                    if (clientSocket == null) continue;
                    clientSocket.close();
                    continue;
                }
                catch (IOException closeioe) {
                    this.parent.consoleExceptionPrintTrace(closeioe);
                    continue;
                }
            }
            break;
        }
    }
}

