/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.epr;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.il.epr.MutableEndpoint;
import org.apache.ode.il.epr.URLEndpoint;
import org.apache.ode.il.epr.WSAEndpoint;
import org.apache.ode.il.epr.WSDL11Endpoint;
import org.apache.ode.il.epr.WSDL20Endpoint;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointFactory {
    private static final Log __log = LogFactory.getLog(EndpointFactory.class);
    private static QName WSDL20_ELMT_QNAME = new QName("http://www.w3.org/2006/01/wsdl", "service");
    private static QName WSDL11_ELMT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "service");
    private static QName WSA_ELMT_QNAME = new QName("http://www.w3.org/2005/08/addressing", "EndpointReference");
    private static QName SOAP_ADDR_ELMT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static MutableEndpoint[] ENDPOINTS = new MutableEndpoint[]{new URLEndpoint(), new WSAEndpoint(), new WSDL11Endpoint(), new WSDL20Endpoint()};

    public static MutableEndpoint createEndpoint(Element element) {
        for (MutableEndpoint mutableEndpoint : ENDPOINTS) {
            MutableEndpoint mutableEndpoint2;
            if (!mutableEndpoint.accept(element)) continue;
            try {
                mutableEndpoint2 = (MutableEndpoint)mutableEndpoint.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            mutableEndpoint2.set(element);
            return mutableEndpoint2;
        }
        __log.warn((Object)("Couldnt create any endpoint for element " + DOMUtils.domToString((Node)element)));
        return null;
    }

    public static MutableEndpoint convert(QName qName, Element element) {
        MutableEndpoint mutableEndpoint = EndpointFactory.createEndpoint(element);
        Map map = mutableEndpoint.toMap();
        MutableEndpoint mutableEndpoint2 = qName == null ? new URLEndpoint() : (qName.equals(WSDL20_ELMT_QNAME) ? new WSDL20Endpoint() : (qName.equals(WSDL11_ELMT_QNAME) ? new WSDL11Endpoint() : (qName.equals(WSA_ELMT_QNAME) ? new WSAEndpoint() : (qName.equals(SOAP_ADDR_ELMT_QNAME) ? new URLEndpoint() : new URLEndpoint()))));
        mutableEndpoint2.fromMap(map);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Converted endpoint to type " + qName));
            __log.debug((Object)("Source endpoint " + DOMUtils.domToString((Node)element)));
            __log.debug((Object)("Destination endpoint " + DOMUtils.domToString((Node)mutableEndpoint2.toXML())));
        }
        return mutableEndpoint2;
    }

    public static WSAEndpoint convertToWSA(MutableEndpoint mutableEndpoint) {
        if (mutableEndpoint == null) {
            return null;
        }
        if (mutableEndpoint instanceof WSAEndpoint) {
            return (WSAEndpoint)mutableEndpoint;
        }
        return new WSAEndpoint(mutableEndpoint.toMap());
    }
}

