/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.webservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Properties;

public class WebserviceProperties {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8081";
    public static final String DEFAULT_WEBROOT = "/";
    public static final String PROP_HOSTNAME = "webservice.hostname";
    public static final String PROP_PORT = "webservice.port";
    public static final String PROP_WEBROOT = "webservice.webroot";
    private String _hostname = WebserviceProperties.findDefaultHost();
    private String _port = "8081";
    private String _webroot = "/";

    public WebserviceProperties() {
    }

    public WebserviceProperties(Properties props) {
        this();
        this.initialize(props);
    }

    public WebserviceProperties(InputStream propertyFile) throws IOException {
        this();
        Properties props = new Properties();
        props.load(propertyFile);
        this.initialize(props);
    }

    private void initialize(Properties props) {
        this.setHostname(props.getProperty(PROP_HOSTNAME, this._hostname));
        this.setPort(props.getProperty(PROP_PORT, this._port));
        this.setWebroot(props.getProperty(PROP_WEBROOT, this._webroot));
    }

    private static String findDefaultHost() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostName();
        }
        catch (Exception exception) {
            return DEFAULT_HOST;
        }
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getPort() {
        return this._port;
    }

    public String getWebroot() {
        return this._webroot;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public void setWebroot(String webroot) {
        this._webroot = webroot.trim();
        if (webroot.length() == 0) {
            this._webroot = DEFAULT_WEBROOT;
        } else {
            if (this._webroot.charAt(0) != '/') {
                this._webroot = String.valueOf('/') + this._webroot;
            }
            if (this._webroot.charAt(this._webroot.length() - 1) != '/') {
                this._webroot = String.valueOf(this._webroot) + '/';
            }
        }
    }

    public String getBaseURL() {
        return "http://" + this._hostname + ":" + this._port + this._webroot;
    }
}

