/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.tika.internal;

import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.language.LanguageIdentifier;
import org.eclipse.smila.common.language.Language;
import org.eclipse.smila.common.language.LanguageIdentifyService;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class TikaLanguageIdentifyService
implements LanguageIdentifyService {
    public static final String BUNDLE_ID = "org.eclipse.smila.tika";
    public static final String LANGUAGE_MAPPING = "languageMapping.properties";
    private final Log _log = LogFactory.getLog(this.getClass());
    private Properties _langMapping;

    protected void activate(ComponentContext context) {
        InputStream propStream = ConfigUtils.getConfigStream((String)BUNDLE_ID, (String)LANGUAGE_MAPPING);
        try {
            try {
                this._langMapping = new Properties();
                this._langMapping.load(propStream);
            }
            catch (Throwable ex) {
                this._log.error((Object)"Error while activating org.eclipse.smila.tika", ex);
                throw new RuntimeException("Error while activating org.eclipse.smila.tika", ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)propStream);
        }
    }

    public Language identify(String content) {
        if (content == null || "".equals(content)) {
            return null;
        }
        LanguageIdentifier langIdentifier = new LanguageIdentifier(content);
        String isoLanguage = langIdentifier.getLanguage();
        boolean isCertain = langIdentifier.isReasonablyCertain();
        String alternativeName = this._langMapping.getProperty(isoLanguage);
        if (alternativeName != null && "".equals(alternativeName.trim())) {
            alternativeName = null;
        }
        Language lang = new Language(isoLanguage, alternativeName, isCertain);
        return lang;
    }

    public Set<String> getSupportedLanguages() {
        return LanguageIdentifier.getSupportedLanguages();
    }

    public String getAlternativeName(String isoLanguage) {
        if (isoLanguage == null) {
            return null;
        }
        String alternativeName = this._langMapping.getProperty(isoLanguage);
        if (alternativeName != null && "".equals(alternativeName.trim())) {
            alternativeName = null;
        }
        return alternativeName;
    }
}

