/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.service;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.il.DynamicService;

public class ManagementService {
    private static final Log __log = LogFactory.getLog(ManagementService.class);
    public static final QName PM_SERVICE_NAME = new QName("http://www.apache.org/ode/pmapi", "ProcessManagementService");
    public static final String PM_PORT_NAME = "ProcessManagementPort";
    public static final String PM_AXIS2_NAME = "ProcessManagement";
    public static final QName IM_SERVICE_NAME = new QName("http://www.apache.org/ode/pmapi", "InstanceManagementService");
    public static final String IM_PORT_NAME = "InstanceManagementPort";
    public static final String IM_AXIS2_NAME = "InstanceManagement";
    private ProcessManagement _processMgmt;
    private InstanceManagement _instanceMgmt;

    public void enableService(AxisConfiguration axisConfiguration, BpelServer bpelServer, ProcessStore processStore, String string) {
        ProcessAndInstanceManagementImpl processAndInstanceManagementImpl = new ProcessAndInstanceManagementImpl(bpelServer, processStore);
        this._processMgmt = processAndInstanceManagementImpl;
        this._instanceMgmt = processAndInstanceManagementImpl;
        try {
            WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
            wSDLReader.setFeature("javax.wsdl.verbose", false);
            File file = new File(string + "/pmapi.wsdl");
            Definition definition = wSDLReader.readWSDL(file.toURI().toString());
            AxisService axisService = ODEAxisService.createService(axisConfiguration, PM_SERVICE_NAME, PM_PORT_NAME, PM_AXIS2_NAME, definition, new DynamicMessageReceiver<ProcessManagement>(this._processMgmt));
            AxisService axisService2 = ODEAxisService.createService(axisConfiguration, IM_SERVICE_NAME, IM_PORT_NAME, IM_AXIS2_NAME, definition, new DynamicMessageReceiver<InstanceManagement>(this._instanceMgmt));
            axisConfiguration.addService(axisService);
            axisConfiguration.addService(axisService2);
        }
        catch (WSDLException wSDLException) {
            __log.error((Object)"Couldn't start-up management services!", (Throwable)wSDLException);
        }
        catch (IOException iOException) {
            __log.error((Object)"Couldn't start-up management services!", (Throwable)iOException);
        }
    }

    public ProcessManagement getProcessMgmt() {
        return this._processMgmt;
    }

    public InstanceManagement getInstanceMgmt() {
        return this._instanceMgmt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DynamicMessageReceiver<T>
    extends AbstractMessageReceiver {
        T _service;

        public DynamicMessageReceiver(T t) {
            this._service = t;
        }

        public void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
            DynamicService dynamicService = new DynamicService(this._service);
            MessageContext messageContext2 = Utils.createOutMessageContext((MessageContext)messageContext);
            messageContext2.getOperationContext().addMessageContext(messageContext2);
            SOAPFactory sOAPFactory = this.getSOAPFactory(messageContext);
            SOAPEnvelope sOAPEnvelope = sOAPFactory.getDefaultEnvelope();
            messageContext2.setEnvelope(sOAPEnvelope);
            try {
                OMElement oMElement = dynamicService.invoke(messageContext.getAxisOperation().getName().getLocalPart(), messageContext.getEnvelope().getBody().getFirstElement());
                if (oMElement != null) {
                    sOAPEnvelope.getBody().addChild((OMNode)oMElement);
                }
            }
            catch (Exception exception) {
                sOAPEnvelope.getBody().addFault(this.toSoapFault(exception, sOAPFactory));
            }
            AxisEngine.send((MessageContext)messageContext2);
        }

        private SOAPFault toSoapFault(Exception exception, SOAPFactory sOAPFactory) {
            SOAPFault sOAPFault = sOAPFactory.createSOAPFault();
            SOAPFaultCode sOAPFaultCode = sOAPFactory.createSOAPFaultCode(sOAPFault);
            sOAPFaultCode.setText(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"));
            SOAPFaultReason sOAPFaultReason = sOAPFactory.createSOAPFaultReason(sOAPFault);
            sOAPFaultReason.setText(exception.toString());
            OMElement oMElement = sOAPFactory.createOMElement(new QName("http://www.apache.org/ode/pmapi/types/2006/08/02/", exception.getClass().getSimpleName()));
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            oMElement.setText(stringWriter.toString());
            SOAPFaultDetail sOAPFaultDetail = sOAPFactory.createSOAPFaultDetail(sOAPFault);
            sOAPFaultDetail.addDetailEntry(oMElement);
            return sOAPFault;
        }
    }
}

