/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.ode.bpel.rtrep.v2.channels.ReadWriteLockChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ReadWriteLockChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;

public class READWRITELOCK
extends JacobRunnable {
    private static final long serialVersionUID = -7415586067226921615L;
    private LinkedList<Waiter> _waiters = new LinkedList();
    private HashSet<SynchChannel> _owners = new HashSet();
    private Status _status = Status.UNLOCKED;
    private ReadWriteLockChannel _self;

    public READWRITELOCK(ReadWriteLockChannel readWriteLockChannel) {
        this._self = readWriteLockChannel;
    }

    public void run() {
        READWRITELOCK.object((ChannelListener)new ReadWriteLockChannelListener(this._self){
            private static final long serialVersionUID = -8644268413754259515L;

            public void readLock(SynchChannel synchChannel) {
                switch (READWRITELOCK.this._status) {
                    case UNLOCKED: {
                        READWRITELOCK.this._status = Status.READLOCK;
                        READWRITELOCK.this._owners.add(synchChannel);
                        synchChannel.ret();
                        break;
                    }
                    case READLOCK: {
                        READWRITELOCK.this._owners.add(synchChannel);
                        synchChannel.ret();
                        break;
                    }
                    case WRITELOCK: {
                        READWRITELOCK.this._waiters.add(new Waiter(synchChannel, false));
                    }
                }
                1.instance((JacobRunnable)READWRITELOCK.this);
            }

            public void writeLock(SynchChannel synchChannel) {
                switch (READWRITELOCK.this._status) {
                    case UNLOCKED: {
                        READWRITELOCK.this._status = Status.WRITELOCK;
                        READWRITELOCK.this._owners.add(synchChannel);
                        synchChannel.ret();
                        break;
                    }
                    case READLOCK: {
                        READWRITELOCK.this._waiters.add(new Waiter(synchChannel, true));
                        break;
                    }
                    case WRITELOCK: {
                        READWRITELOCK.this._waiters.add(new Waiter(synchChannel, false));
                    }
                }
                1.instance((JacobRunnable)READWRITELOCK.this);
            }

            public void unlock(SynchChannel synchChannel) {
                READWRITELOCK.this._owners.remove(synchChannel);
                if (READWRITELOCK.this._owners.isEmpty()) {
                    READWRITELOCK.this._status = Status.UNLOCKED;
                    if (!READWRITELOCK.this._waiters.isEmpty()) {
                        Waiter waiter = (Waiter)READWRITELOCK.this._waiters.removeFirst();
                        READWRITELOCK.this._owners.add(waiter.synch);
                        READWRITELOCK.this._status = waiter.write ? Status.WRITELOCK : Status.READLOCK;
                        waiter.synch.ret();
                        if (READWRITELOCK.this._status == Status.READLOCK) {
                            Iterator iterator = READWRITELOCK.this._waiters.iterator();
                            while (iterator.hasNext()) {
                                Waiter waiter2 = (Waiter)iterator.next();
                                if (waiter2.write) break;
                                READWRITELOCK.this._owners.add(waiter2.synch);
                                waiter2.synch.ret();
                                iterator.remove();
                            }
                        }
                    }
                }
                1.instance((JacobRunnable)READWRITELOCK.this);
            }
        });
    }

    private static class Waiter {
        SynchChannel synch;
        boolean write;

        Waiter(SynchChannel synchChannel, boolean bl) {
            this.synch = synchChannel;
            this.write = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        UNLOCKED,
        READLOCK,
        WRITELOCK;

    }
}

