/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.crawler.jdbc.JdbcCrawlingContext;
import org.eclipse.smila.importing.util.RecordOutputHandler;
import org.eclipse.smila.jdbc.JdbcAccessService;
import org.eclipse.smila.jdbc.SqlExecutor;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.utils.digest.DigestHelper;

public class JdbcCrawlerWorker
implements Worker {
    public static final String NAME = "jdbcCrawler";
    public static final String OUTPUT_SLOT_CRAWLED_RECORDS = "crawledRecords";
    public static final String INPUT_SLOT_SPLITS_TO_CRAWL = "splitsToCrawl";
    public static final String OUTPUT_SLOT_SPLITS_TO_CRAWL = "splitsToCrawl";
    public static final String TASK_PARAM_MAX_RECORDS_PER_BULK = "maxRecordsPerBulk";
    public static final String TASK_PARAM_DB_URL = "dbUrl";
    public static final String TASK_PARAM_DB_PROPS = "dbProps";
    public static final String TASK_PARAM_CRAWL_SQL = "crawlSql";
    public static final String TASK_PARAM_ID_COLUMNS = "idColumns";
    public static final String TASK_PARAM_DELTA_COLUMNS = "deltaColumns";
    public static final String TASK_PARAM_MAX_ATTACHMENT_SIZE = "maxAttachmentSize";
    public static final String TASK_PARAM_SPLIT_INCREMENT = "splitIncrement";
    public static final String TASK_PARAM_SPLIT_LIMITS_SQL = "splitLimitsSql";
    public static final Long MAX_RECORDS_PER_BULK_DEFAULT = 1000L;
    public static final Long MAX_ATTACHMENT_SIZE_DEFAULT = 1000000000L;
    private static final String COLUMN_SEPARATOR = "-";
    private static final String SPLIT_MIN = "MIN";
    private static final String SPLIT_MAX = "MAX";
    private final Log _log = LogFactory.getLog(this.getClass());
    private JdbcAccessService _jdbcAccess;

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        try {
            Inputs inputs = taskContext.getInputs();
            JdbcCrawlingContext crawlContext = new JdbcCrawlingContext(taskContext);
            if (!inputs.getSlotNames().contains("splitsToCrawl") || inputs.getDataObjectCount("splitsToCrawl") == 0) {
                this.initiateCrawling(crawlContext);
            } else {
                RecordInput splitsToCrawl = inputs.getAsRecordInput("splitsToCrawl");
                this.crawlSplits(splitsToCrawl, crawlContext);
            }
        }
        catch (Exception e) {
            this._log.error((Object)e);
            throw e;
        }
    }

    public void setJdbcAccessService(JdbcAccessService jdbcAccess) {
        this._jdbcAccess = jdbcAccess;
    }

    public void unsetJdbcAccessService(JdbcAccessService jdbcAccess) {
        if (this._jdbcAccess == jdbcAccess) {
            this._jdbcAccess = null;
        }
    }

    private void initiateCrawling(JdbcCrawlingContext crawlContext) throws Exception {
        AnyMap splitIntervalMetaData = this.determineSplitInterval(crawlContext);
        Long min = null;
        Long max = null;
        if (splitIntervalMetaData != null) {
            min = splitIntervalMetaData.getLongValue(SPLIT_MIN);
            max = splitIntervalMetaData.getLongValue(SPLIT_MAX);
        }
        if (min != null && max != null) {
            this.createAndSendSplitRecords(crawlContext, min, max);
        } else {
            this.crawl(crawlContext, null);
        }
    }

    private void createAndSendSplitRecords(JdbcCrawlingContext crawlContext, Long min, Long max) throws IOException, ObjectStoreException {
        long splitEnd;
        RecordOutputHandler splitsToCrawlBulks = new RecordOutputHandler(crawlContext.getTaskContext().getOutputs(), 1L, "splitsToCrawl");
        long splitStart = min;
        do {
            splitEnd = Math.min(max, splitStart + crawlContext.getSplitIncrement() - 1L);
            Record splitsToCrawlRecord = DataFactory.DEFAULT.createRecord();
            splitsToCrawlRecord.getMetadata().put(SPLIT_MIN, (Number)splitStart);
            splitsToCrawlRecord.getMetadata().put(SPLIT_MAX, (Number)splitEnd);
            splitsToCrawlBulks.writeRecord(splitsToCrawlRecord);
        } while ((splitStart = splitEnd + 1L) <= max);
    }

    private AnyMap determineSplitInterval(JdbcCrawlingContext crawlContext) throws SQLException, IOException {
        Collection results;
        if (crawlContext.getSplitLimitsSql() != null && (results = this._jdbcAccess.executeSql(crawlContext.getDbUrl(), crawlContext.getDbProperties(), crawlContext.getSplitLimitsSql(), 0L, crawlContext.getMessages())) != null && results.size() > 0) {
            return ((Record)results.iterator().next()).getMetadata();
        }
        return null;
    }

    private void crawlSplits(RecordInput splitsToCrawl, JdbcCrawlingContext crawlContext) throws Exception {
        Record record = splitsToCrawl.getRecord();
        while (record != null && !crawlContext.getTaskContext().isCanceled()) {
            ArrayList<Value> splitValues = new ArrayList<Value>();
            splitValues.add(record.getMetadata().getValue(SPLIT_MIN));
            splitValues.add(record.getMetadata().getValue(SPLIT_MAX));
            this.crawl(crawlContext, splitValues);
            record = splitsToCrawl.getRecord();
        }
    }

    private void crawl(JdbcCrawlingContext crawlContext, List<Value> splitValues) throws Exception {
        Collection results;
        RecordOutputHandler recordBulks = new RecordOutputHandler(crawlContext.getTaskContext().getOutputs(), crawlContext.getMaxRecordsPerBulk(), OUTPUT_SLOT_CRAWLED_RECORDS);
        if (splitValues == null || splitValues.size() < 2) {
            results = this._jdbcAccess.executeSql(crawlContext.getDbUrl(), crawlContext.getDbProperties(), crawlContext.getCrawlSql(), crawlContext.getMaxAttachmentSize(), crawlContext.getMessages());
        } else {
            Throwable throwable = null;
            Object var6_7 = null;
            try (SqlExecutor sqlExecutor = this._jdbcAccess.executePrepared(crawlContext.getDbUrl(), crawlContext.getDbProperties(), crawlContext.getCrawlSql(), crawlContext.getMaxAttachmentSize(), crawlContext.getMessages());){
                results = sqlExecutor.execute(splitValues);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Iterator it = results.iterator();
        while (it.hasNext() && !crawlContext.getTaskContext().isCanceled()) {
            Record record = (Record)it.next();
            this.augmentRecord(record, crawlContext);
            crawlContext.getMapper().mapNames(record, this.getColumnNames(record));
            recordBulks.writeRecord(record);
        }
    }

    private Record augmentRecord(Record record, JdbcCrawlingContext crawlContext) throws ImportingException {
        record.setId(this.createId(crawlContext, record));
        record.setSource(crawlContext.getDataSource());
        record.getMetadata().put("_deltaHash", this.createDeltaHash(crawlContext, record));
        return record;
    }

    private String createId(JdbcCrawlingContext crawlContext, Record record) throws ImportingException {
        return String.valueOf(crawlContext.getDataSource()) + ":" + this.concatColumnValues(crawlContext.getIdColumns(), record);
    }

    private String createDeltaHash(JdbcCrawlingContext crawlContext, Record record) throws ImportingException {
        return this.concatColumnValues(crawlContext.getDeltaColumns(), record);
    }

    private String concatColumnValues(Any columnNames, Record record) throws ImportingException {
        StringBuffer idBuffer = new StringBuffer();
        if (columnNames != null) {
            AnyMap metadata = record.getMetadata();
            for (Any column : columnNames) {
                String columnName = column.asValue().asString();
                if (metadata.containsKey((Object)columnName)) {
                    String value = metadata.getStringValue(columnName);
                    if (value.length() > 100) {
                        value = DigestHelper.calculateDigest((String)value);
                    }
                    idBuffer.append(value);
                } else if (record.hasAttachment(columnName)) {
                    idBuffer.append(DigestHelper.calculateDigest((byte[])record.getAttachmentAsBytes(columnName)));
                } else {
                    idBuffer.append("NULL");
                }
                idBuffer.append(COLUMN_SEPARATOR);
            }
            idBuffer.deleteCharAt(idBuffer.length() - 1);
        }
        return idBuffer.toString();
    }

    private Set<String> getColumnNames(Record resultRecord) {
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(resultRecord.getMetadata().keySet());
        columnNames.remove("_recordid");
        columnNames.remove("_source");
        columnNames.remove("_deltaHash");
        Iterator it = resultRecord.getAttachmentNames();
        while (it.hasNext()) {
            columnNames.add((String)it.next());
        }
        return columnNames;
    }
}

