/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;

public class SOAPBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        try {
            String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            PushbackInputStream pis = BuilderUtil.getPushbackInputStream(inputStream);
            String actualCharSetEncoding = BuilderUtil.getCharSetEncoding(pis, charSetEncoding);
            XMLStreamReader streamReader = StAXUtils.createXMLStreamReader((InputStream)pis, (String)actualCharSetEncoding);
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(streamReader);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            BuilderUtil.validateSOAPVersion(BuilderUtil.getEnvelopeNamespace(contentType), envelope);
            BuilderUtil.validateCharSetEncoding(charSetEncoding, builder.getDocument().getCharsetEncoding(), envelope.getNamespace().getNamespaceURI());
            return envelope;
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
    }
}

