/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.compounds.simple;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.compounds.simple.SimpleCompoundExtractorService;

final class AttachmentSettingIterator
implements Iterator<Record> {
    private final Log _log = LogFactory.getLog(SimpleCompoundExtractorService.class);
    private final File _tmpDir;
    private final List<Record> _records;
    private final String _contentAttachmentName;
    private int _index;

    AttachmentSettingIterator(List<Record> records, String contentAttachmentName, File tmpDir) {
        this._tmpDir = tmpDir;
        this._records = records;
        this._contentAttachmentName = contentAttachmentName;
    }

    @Override
    public boolean hasNext() {
        return this._index < this._records.size();
    }

    @Override
    public Record next() {
        Record record = this._records.set(this._index, null);
        ++this._index;
        if (record != null && record.getMetadata().containsKey((Object)"tmpFileName")) {
            File file = new File(record.getMetadata().getStringValue("tmpFileName"));
            try {
                record.setAttachment(this._contentAttachmentName, FileUtils.readFileToByteArray((File)file));
            }
            catch (IOException e) {
                this._log.warn((Object)("Cannot access temporary extracted file '" + file.getAbsolutePath() + "'."), (Throwable)e);
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        if (!this.hasNext()) {
            try {
                FileUtils.deleteDirectory((File)this._tmpDir);
            }
            catch (IOException iOException) {
                this._log.warn((Object)("Could not remove temporary directory '" + this._tmpDir.getAbsolutePath() + "'."));
            }
        }
        return record;
    }

    protected void finalize() {
        try {
            if (this.hasNext()) {
                FileUtils.deleteDirectory((File)this._tmpDir);
            }
        }
        catch (IOException iOException) {
            this._log.warn((Object)("Could not remove temporary directory '" + this._tmpDir.getAbsolutePath() + "'."));
        }
        try {
            super.finalize();
        }
        catch (Throwable t) {
            this._log.warn((Object)"Error while cleaning up iterator. ", t);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

