/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.httphandler;

import java.net.MalformedURLException;
import java.util.List;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.VisitedLinksException;
import org.eclipse.smila.importing.httphandler.AVisitedHandler;

public class VisitedSourceHandler
extends AVisitedHandler {
    private static final String FLAG_COUNTEXACT = "countExact";

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "DELETE".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String sourceId = this.getSourceId(requestUri);
        if ("DELETE".equals(method)) {
            return this.clearSource(sourceId);
        }
        return this.getSourceInfo(requestUri, sourceId, inputRecord);
    }

    private String getSourceId(String requestUri) {
        List dynamics = this.getDynamicUriParts(requestUri);
        if (dynamics.isEmpty()) {
            throw new IllegalArgumentException("Invalid URI " + requestUri + " for this handler, no source ID found.");
        }
        return (String)dynamics.get(0);
    }

    private Object clearSource(String sourceId) throws VisitedLinksException {
        this._visitedService.clearSource(sourceId);
        return null;
    }

    private AnyMap getSourceInfo(String requestUri, String sourceId, Record inputRecord) throws DeltaException, MalformedURLException {
        Any countExactParam;
        AnyMap source = DataFactory.DEFAULT.createAnyMap();
        boolean countExact = false;
        if (inputRecord != null && (countExactParam = (Any)inputRecord.getMetadata().get((Object)FLAG_COUNTEXACT)) != null && countExactParam.isBoolean()) {
            countExact = countExactParam.asValue().asBoolean();
        }
        source.put("id", sourceId);
        source.put("count", (Number)this._visitedService.countEntries(sourceId, countExact));
        return source;
    }
}

