/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.util;

import java.io.IOException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public final class RecordOutputHandler {
    private final Outputs _outputs;
    private final String _slotName;
    private RecordOutput _recordOutput;
    private int _bulkCount;
    private int _recordCount;
    private final long _maxRecordsPerBulk;

    public RecordOutputHandler(Outputs outputs, long maxRecordsPerBulk, String slotName) {
        this._outputs = outputs;
        this._slotName = slotName;
        this._maxRecordsPerBulk = maxRecordsPerBulk;
        this._recordCount = 0;
        this._bulkCount = 0;
        this._recordOutput = outputs.getAsRecordOutput(this._slotName, this._bulkCount);
    }

    public void writeRecord(Record record) throws IOException, ObjectStoreException {
        this._recordOutput.writeRecord(record);
        ++this._recordCount;
        if ((long)this._recordCount % this._maxRecordsPerBulk == 0L) {
            this._recordOutput.commit();
            ++this._bulkCount;
            this._recordOutput = this._outputs.getAsRecordOutput(this._slotName, this._bulkCount);
        }
    }

    public int getFileCount() {
        return this._recordCount;
    }
}

