/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.workermanager;

import org.eclipse.smila.taskmanager.Task;

/**
 * Listener for TaskKeepAlive keep alive-failures.
 * 
 * If the {@link TaskKeepAlive} gets to know that a {@link Task} (that is currently being kept alive) has been removed
 * by the TaskManager the method {@link TaskKeepAliveListener#removedTask(Task)} will be called.
 */
public interface TaskKeepAliveListener {

  /**
   * Called if the {@link TaskKeepAlive} gets to know that a {@link Task} (that is currently being kept alive) has been
   * removed by the TaskManager.
   * 
   * @param task
   *          the task that has been removed.
   */
  void removedTask(final Task task);
}
