/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.taskmanager.Task;

/**
 * RunOnce Trigger Task Generator implementation.
 */
public class RunOnceTriggerTaskGenerator extends DefaultTaskGenerator {

  /**
   * Creates a list of tasks for given input buckets. One task will be generated for each input bucket and in the store
   * an empty bulk object will be created.
   * 
   * @param inputBuckets
   *          key: input slot name, value: bucket for this slot
   * @param outputBuckets
   *          key: output slot name, value: bucket for this slot
   * @param parameters
   *          key: param name, value: (evaluated) param value
   * @param workerName
   *          (action) worker for which to create new tasks
   * @return a list of new generated tasks
   */
  @Override
  protected List<Task> doCreateRunOnceTasks(final Map<String, Bucket> inputBuckets,
    final Map<String, Bucket> outputBuckets, final AnyMap parameters, final String workerName) {
    final List<Task> taskList = new ArrayList<Task>();
    final Task task = createTask(workerName, parameters);
    final AnyMap bulkParameters = parameters.getFactory().cloneAnyMap(task.getParameters());
    addOutputBulks(task, null, outputBuckets, bulkParameters);
    taskList.add(task);
    return taskList;
  }

  /** {@inheritDoc}. But there is no check for the number of buckets. */
  @Override
  public List<Task> createRunOnceTasks(final Map<String, Bucket> inputBuckets,
    final Map<String, Bucket> outputBuckets, final AnyMap parameters, final String workerName)
    throws TaskGeneratorException {
    try {
      return doCreateRunOnceTasks(inputBuckets, outputBuckets, parameters, workerName);
    } catch (final Exception e) {
      throw new TaskGeneratorException("Cannot create tasks for mode '" + JobRunMode.RUNONCE.name()
        + "' and worker '" + workerName + "'.", e);
    }
  }
}
