/*******************************************************************************
 * Copyright (c) 2008, 2009 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.utils.xml.stax;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Extracts the contents of specific tags from an XML stream.
 */
public class SimpleTagExtractor {

  /** Indicates to return the content only, without the surrounding tags. */
  private boolean _removeTags;

  /**
   * Creates a new instance.
   * 
   * @param removeTags
   *          {@code true} to return the contents of the only, without the surrounding tags
   */
  public SimpleTagExtractor(final boolean removeTags) {
    _removeTags = removeTags;
  }

  /**
   * Reads all tags with the given name from the given XML stream.
   * 
   * The namespace of the tags is ignored.
   * 
   * @param tagName
   *          the name of the tag
   * @param inputStream
   *          contains the XML document
   * @return the contents of all tags with the given local name
   * @throws XMLStreamException
   *           if the stream did not contain a valid XML document
   */
  public synchronized List<String> getTags(final String tagName, final InputStream inputStream)
    throws XMLStreamException {
    final List<String> tags = new ArrayList<String>();
    new XmlSnippetSplitter(new XmlSnippetHandler() {
      @Override
      public void handleSnippet(byte[] snippet) {
        try {
          String tag = new String(snippet, "UTF-8");
          if (_removeTags) {
            tag = tag.substring(tag.indexOf(">") + 1, tag.lastIndexOf("</"));
          }
          tags.add(tag);
        } catch (UnsupportedEncodingException e) {
          // Should not happen, since UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }, new QName(tagName), new QName(tagName)).read(inputStream);

    return tags;
  }

}
