/*******************************************************************************
 * Copyright (c) 2010 Empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) initial implementation
 *******************************************************************************/

package org.eclipse.smila.solr;

import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.solr.admin.SolrAdministrationAgent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * The solr BundleActivator class.
 */
public class Activator implements BundleActivator {

  /**
   * The bundle name.
   */
  public static final String BUNDLE_ID = "org.eclipse.smila.solr";

  /**
   * this instance is set and unset by the activator, so it might return null depending on the state of the bundle but
   * otherwise this servers as a static handle to get to the important stuff of this bundle.
   */
  private static Activator s_instance;

  /**
   * The SolrManager instance.
   */
  private SolrManager _serverManager;

  /**
   * Get activator instance.
   * 
   * @return the activator instance.
   */
  public static Activator getInstance() {
    return s_instance;
  }

  /** set instance for access via {@link #getInstance()}. */
  private static void setInstance(final Activator instance) {
    s_instance = instance;
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
   */
  @Override
  public void start(BundleContext context) throws Exception {
    setInstance(this);
    _serverManager = new SolrManager();
    ManagementRegistration.INSTANCE.registerAgent(new SolrAdministrationAgent(_serverManager
      .getSolrAdministration()));

  }

  /**
   * {@inheritDoc}
   * 
   * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
   */
  @Override
  public void stop(BundleContext context) throws Exception {
    setInstance(null);
  }

  /**
   * Get SolrManager.
   * 
   * @return the SolrManager.
   */
  public SolrManager getSolrManager() {
    return _serverManager;
  }

}
