/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.ccil.cowan.tagsoup.Parser;
import org.eclipse.smila.common.logging.MessageCollector;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.crawler.web.extractor.LinkExtractorHtml;
import org.eclipse.smila.importing.crawler.web.utils.UriHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LinkExtractorHtmlSoup
implements LinkExtractorHtml {
    @Override
    public Collection<String> extractLinks(InputStream input, AnyMap parameters, MessageCollector messageCollector) throws Exception {
        LinkContentHandler linkHandler = new LinkContentHandler();
        Parser parser = new Parser();
        parser.setContentHandler(linkHandler);
        parser.setFeature("http://xml.org/sax/features/namespaces", false);
        try {
            parser.parse(new InputSource(input));
        }
        catch (IOException e) {
            messageCollector.add("Error during parsing of document: " + e.getMessage());
        }
        return linkHandler._links;
    }

    private static class LinkContentHandler
    extends DefaultHandler {
        private final Collection<String> _links = new ArrayList<String>();
        private String _base;

        private LinkContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String link = null;
            if (qName.equalsIgnoreCase("a")) {
                link = atts.getValue("href");
            } else if (qName.equalsIgnoreCase("frame") || qName.equalsIgnoreCase("img")) {
                link = atts.getValue("src");
            } else if (qName.equalsIgnoreCase("base")) {
                this._base = atts.getValue("href");
            }
            if (link != null && !link.isEmpty()) {
                try {
                    if (this._base != null && !new URI(link).isAbsolute()) {
                        link = UriHelper.makeAbsolute(this._base, link);
                    }
                    this._links.add(link);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            super.startElement(uri, localName, qName, atts);
        }
    }
}

