/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.internal;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.conversion.DataSizeParser;

public class HttpServerProperties {
    private static final String FILENAME = "httpserver.properties";
    private final Properties _properties = new Properties();
    private final Log _log = LogFactory.getLog(this.getClass());

    public HttpServerProperties() {
        this.loadConfiguration();
    }

    public void loadConfiguration() {
        try {
            InputStream propertyFile = ConfigUtils.getConfigStream((String)"org.eclipse.smila.http.server", (String)FILENAME);
            try {
                try {
                    this._properties.load(propertyFile);
                }
                catch (Exception ex) {
                    this._log.warn((Object)"Failed to load configuration httpserver.properties for bundle org.eclipse.smila.http.server", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)propertyFile);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)propertyFile);
            }
        }
        catch (Exception ex) {
            this._log.info((Object)"No configuration httpserver.properties found for bundle org.eclipse.smila.http.server", (Throwable)ex);
        }
    }

    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this._properties.getProperty(key, defaultValue);
    }

    public long getDataSize(String key, String defaultValue) {
        try {
            return DataSizeParser.parse((String)this.getProperty(key, defaultValue));
        }
        catch (Exception ex) {
            this._log.info((Object)("Failed to parse configured value for " + key), (Throwable)ex);
            return DataSizeParser.parse((String)defaultValue);
        }
    }
}

