/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.restapi;

import java.util.Map;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.taskmanager.TaskCounter;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.versions.VersionManager;

public class StateHandler
extends JsonRequestHandler {
    private TaskManager _taskManager;
    private VersionManager _versionManager;
    private ClusterConfigService _clusterConfig;

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) {
        AnyMap result = FACTORY.createAnyMap();
        result.put("version", (Any)this._versionManager.getVersionInfos());
        result.put("cluster", (Any)this.buildClusterSection());
        result.put("taskmanager", (Any)this.buildTaskManagerSection());
        result.put("api", (Any)this.buildApiSection(this.getRequestHost(exchange), requestUri));
        return result;
    }

    private AnyMap buildClusterSection() {
        try {
            AnyMap clusterSection = FACTORY.createAnyMap();
            AnySeq nodes = FACTORY.createAnySeq();
            for (String node : this._clusterConfig.getClusterNodes()) {
                nodes.add(node);
            }
            clusterSection.put("nodes", (Any)nodes);
            return clusterSection;
        }
        catch (Exception e) {
            return this.buildErrorSection(e);
        }
    }

    private AnyMap buildTaskManagerSection() {
        AnyMap taskManagerSection = FACTORY.createAnyMap();
        try {
            int todoCount = 0;
            int inprogressCount = 0;
            Map counters = this._taskManager.getTaskCounters();
            for (TaskCounter counter : counters.values()) {
                todoCount += counter.getTasksTodo();
                inprogressCount += counter.getTasksInProgress();
            }
            taskManagerSection.put("todo", (Number)todoCount);
            taskManagerSection.put("inprogress", (Number)inprogressCount);
            return taskManagerSection;
        }
        catch (Exception e) {
            return this.buildErrorSection(e);
        }
    }

    private AnyMap buildApiSection(String requestHost, String requestUri) {
        AnyMap section = FACTORY.createAnyMap();
        try {
            section.put("jobmanager", URLCreator.create((String)requestHost, (String)requestUri, (String)"jobmanager").toString());
            section.put("tasks", URLCreator.create((String)requestHost, (String)requestUri, (String)"tasks").toString());
            section.put("pipelines", URLCreator.create((String)requestHost, (String)requestUri, (String)"pipeline").toString());
            section.put("pipelets", URLCreator.create((String)requestHost, (String)requestUri, (String)"pipelets").toString());
            section.put("store", URLCreator.create((String)requestHost, (String)requestUri, (String)"store").toString());
            section.put("importing", URLCreator.create((String)requestHost, (String)requestUri, (String)"importing").toString());
        }
        catch (Exception e) {
            section.put("error", String.valueOf(e.getClass().getCanonicalName()) + ": " + e.getMessage());
        }
        return section;
    }

    private AnyMap buildErrorSection(Exception e) {
        AnyMap errorSection = FACTORY.createAnyMap();
        errorSection.put("error", (Any)AnyUtil.exceptionToAny((Throwable)e));
        return errorSection;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (taskManager == this._taskManager) {
            this._taskManager = null;
        }
    }

    public void setVersionManager(VersionManager versionManager) {
        this._versionManager = versionManager;
    }

    public void unsetVersionManager(VersionManager versionManager) {
        if (versionManager == this._versionManager) {
            this._versionManager = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService clusterConfig) {
        this._clusterConfig = clusterConfig;
    }

    public void unsetClusterConfigService(ClusterConfigService clusterConfig) {
        if (clusterConfig == this._clusterConfig) {
            this._clusterConfig = null;
        }
    }
}

