/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.persistence.BinaryPersistence;

public class BinaryPersistenceFactory {
    public static BinaryPersistence newImplInstance(BinaryStorageConfiguration configuration) throws BinaryStorageException {
        try {
            Class<?> clazz = Class.forName(configuration.getImplementationClass());
            Constructor<?> implConstructor = clazz.getConstructor(BinaryStorageConfiguration.class);
            BinaryPersistence binaryPersistence = (BinaryPersistence)implConstructor.newInstance(configuration);
            return binaryPersistence;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid BinaryPersistence configuration", exception);
        }
        finally {
            Log log = LogFactory.getLog(BinaryPersistenceFactory.class);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created new BinaryPersistence implementation instance :" + configuration.getImplementationClass()));
            }
        }
    }

    private BinaryPersistenceFactory() {
    }
}

