/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyConvertException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;

public class BulkInfo {
    public static final String KEY_BUCKET = "bucket";
    public static final String KEY_STORE = "store";
    public static final String KEY_ID = "id";
    private final String _bucketName;
    private final String _storeName;
    private final String _objectName;

    public BulkInfo(String bucketName, String storeName, String objectName) {
        this._bucketName = bucketName;
        this._storeName = storeName;
        this._objectName = objectName;
    }

    public static BulkInfo fromAny(Any any) throws AnyConvertException {
        if (!(any instanceof AnyMap)) {
            throw new AnyConvertException("Error parsing task from Any object that is no Map.");
        }
        try {
            AnyMap bulkAny = (AnyMap)any;
            String bucket = bulkAny.getStringValue(KEY_BUCKET);
            String store = bulkAny.getStringValue(KEY_STORE);
            String name = bulkAny.getStringValue(KEY_ID);
            return new BulkInfo(bucket, store, name);
        }
        catch (Exception ex) {
            throw new AnyConvertException("Error parsing BulkInfo from Any object", (Throwable)ex);
        }
    }

    public String getBucketName() {
        return this._bucketName;
    }

    public String getStoreName() {
        return this._storeName;
    }

    public String getObjectName() {
        return this._objectName;
    }

    public String toString() {
        return "DataObject [_bucketName=" + this._bucketName + ", _storeName=" + this._storeName + ", _objectName=" + this._objectName + "]";
    }

    public int hashCode() {
        int result = 1;
        if (this._bucketName != null) {
            result = 31 * result + this._bucketName.hashCode();
        }
        if (this._objectName != null) {
            result = 31 * result + this._objectName.hashCode();
        }
        if (this._storeName != null) {
            result = 31 * result + this._storeName.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BulkInfo other = (BulkInfo)obj;
        return BulkInfo.equalsObjects(this._bucketName, other._bucketName) && BulkInfo.equalsObjects(this._objectName, other._objectName) && BulkInfo.equalsObjects(this._storeName, other._storeName);
    }

    private static boolean equalsObjects(Object one, Object two) {
        return !(one == null ? two != null : !one.equals(two));
    }

    public AnyMap toAny() {
        AnyMap bulkInfoAny = DataFactory.DEFAULT.createAnyMap();
        bulkInfoAny.put(KEY_BUCKET, this.getBucketName());
        bulkInfoAny.put(KEY_STORE, this.getStoreName());
        bulkInfoAny.put(KEY_ID, this.getObjectName());
        return bulkInfoAny;
    }
}

