/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.httphandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.TaskList;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;

public class TaskTypeStateHandler
extends JsonRequestHandler {
    private TaskManager _taskManager;

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        if ("GET".equals(method)) {
            String requestHost = this.getRequestHost(exchange);
            String workerName = this.getWorkerName(requestUri);
            String sectionName = this.getSection(requestUri);
            return this.buildTaskList(requestHost, requestUri, workerName, sectionName);
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex.getCause() != null && ex.getCause() instanceof BadParameterTaskmanagerException) {
            return 404;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private Map<String, Object> buildTaskList(String requestHost, String requestUri, String taskPipe, String taskQueueSubType) throws TaskmanagerException, MalformedURLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        TaskList taskList = this._taskManager.getTaskList(taskPipe, taskQueueSubType, 100);
        result.put("count", taskList.getSize());
        ArrayList<String> taskIDs = new ArrayList<String>();
        for (String taskName : taskList.getTaskNames()) {
            String taskPath = taskName.replaceFirst("/[^/]+/", "");
            URL taskURL = URLCreator.create((String)requestHost, (String)this.getRootContextPath(), (String)taskPath);
            taskIDs.add(taskURL.toString());
        }
        result.put("tasks", taskIDs);
        return result;
    }

    private String getWorkerName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    private String getSection(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(1);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }
}

