/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.common.definitions.NameValidator;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.ode.ODEServerException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.processing.bpel.BpelEngine;
import org.eclipse.smila.processing.bpel.RequestTable;
import org.eclipse.smila.processing.bpel.WorkflowStorage;
import org.eclipse.smila.processing.bpel.WorkflowUpdateWatcher;
import org.eclipse.smila.processing.bpel.counter.PipelinePerformanceCounter;
import org.eclipse.smila.processing.bpel.util.ConfigurationHelper;
import org.eclipse.smila.processing.bpel.util.MessageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BpelWorkflowProcessor
implements WorkflowProcessor {
    private static final String ERROR_CLUSTER_INCONSISTENT = " There may be inconsistencies in cluster deploy of this workflow. Please repeat the operation.";
    private final Log _log = LogFactory.getLog(this.getClass());
    private BpelEngine _bpelEngine;
    private WorkflowStorage _workflowStorage;
    private WorkflowUpdateWatcher _updateWatcher;
    private RequestTable _requests;
    private final Map<String, PipelinePerformanceCounter> _pipelinePerformanceCounter = new HashMap<String, PipelinePerformanceCounter>();
    private final Collection<String> _externalWorkflowNames = new TreeSet<String>();
    private final ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    public String[] process(String workflowName, Blackboard blackboard, String[] recordIds) throws ProcessingException {
        long startTime = System.nanoTime();
        this._lock.readLock().lock();
        String requestId = this._requests.initRequest(blackboard);
        String[] resultIds = null;
        boolean success = false;
        PipelinePerformanceCounter counter = this._pipelinePerformanceCounter.get(workflowName);
        if (this._bpelEngine == null) {
            throw new ProcessingException("Cannot process request, because BPEL engine is not yet initialised");
        }
        MessageHelper messageHelper = this._requests.getMessageHelper();
        Element message = messageHelper.createMessage(blackboard, recordIds, requestId);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("Request: " + DOMUtils.domToString((Node)message)));
        }
        try {
            Element result = this._bpelEngine.invoke(workflowName, message);
            if (result != null) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Final Result: " + DOMUtils.domToString((Node)result)));
                }
                resultIds = messageHelper.parseMessage(blackboard, result);
                success = true;
                String[] stringArray = resultIds;
                this._requests.cleanupRequest(requestId);
                this.countInvocation(recordIds, resultIds, startTime, success, counter);
                this._lock.readLock().unlock();
                return stringArray;
            }
            this._requests.cleanupRequest(requestId);
            this.countInvocation(recordIds, resultIds, startTime, success, counter);
            this._lock.readLock().unlock();
            return null;
        }
        catch (ODEServerException ex) {
            try {
                try {
                    Exception pipeletEx = this._requests.getPipeletException(requestId);
                    String details = pipeletEx == null ? ex.getMessage() : pipeletEx.getMessage();
                    Throwable cause = pipeletEx == null ? ex : pipeletEx;
                    throw new ProcessingException("Error processing BPEL workflow " + workflowName + ": " + details, cause);
                }
                catch (ProcessingException ex2) {
                    this.countError(ex2, false, counter);
                    throw ex2;
                }
                catch (Throwable ex3) {
                    this.countError(ex3, true, counter);
                    throw new ProcessingException(ex3);
                }
            }
            catch (Throwable throwable) {
                this._requests.cleanupRequest(requestId);
                this.countInvocation(recordIds, resultIds, startTime, success, counter);
                this._lock.readLock().unlock();
                throw throwable;
            }
        }
    }

    public List<String> getWorkflowNames() {
        return new ArrayList<String>(this._externalWorkflowNames);
    }

    public AnyMap getWorkflowDefinition(String workflowName) throws ProcessingException {
        try {
            if (this._bpelEngine.isPredefinedWorkflow(workflowName)) {
                return this._bpelEngine.getWorkflow(workflowName);
            }
            if (this._bpelEngine.isCustomWorkflow(workflowName)) {
                return this._workflowStorage.getWorkflow(workflowName);
            }
        }
        catch (Exception ex) {
            throw new ProcessingException("Error reading BPEL definition for workflow '" + workflowName + "'", (Throwable)ex);
        }
        return null;
    }

    public void setWorkflowDefinition(String workflowName, AnyMap workflowDefinition) throws ProcessingException {
        this.checkWorkflowName(workflowName);
        workflowDefinition.remove((Object)"readOnly");
        String timestamp = this.setTimestamp(workflowDefinition);
        File deployDir = this._bpelEngine.validateWorkflow(workflowName, workflowDefinition);
        AnyMap backupWorkflowDefinition = this._workflowStorage.getWorkflow(workflowName);
        try {
            this.deployWorkflowDefinition(workflowName, workflowDefinition, deployDir, timestamp);
        }
        catch (ProcessingException ex) {
            if (backupWorkflowDefinition != null) {
                String backupTimestamp = backupWorkflowDefinition.getStringValue("timestamp");
                try {
                    File backupDeployDir = this._bpelEngine.validateWorkflow(workflowName, backupWorkflowDefinition);
                    this.deployWorkflowDefinition(workflowName, backupWorkflowDefinition, backupDeployDir, backupTimestamp);
                }
                catch (Exception ex2) {
                    this._log.warn((Object)("Failed to rollback workflow definition for workflow '" + workflowName + "'"), (Throwable)ex2);
                }
            }
            throw ex;
        }
    }

    private void deployWorkflowDefinition(String workflowName, AnyMap workflowDefinition, File deployDir, String timestamp) throws ProcessingException {
        try {
            this._bpelEngine.deployWorkflowDir(workflowName, deployDir);
            this.registerPipeline(workflowName);
        }
        catch (Exception e) {
            String errorMessage = "Could not deploy update for workflow '" + workflowName + "': " + e.getMessage();
            throw new ProcessingException(errorMessage, (Throwable)e, false);
        }
        try {
            this._workflowStorage.setWorkflow(workflowName, workflowDefinition);
        }
        catch (Exception e) {
            String errorMessage = "Error while storing workflow definition for '" + workflowName + "'." + ERROR_CLUSTER_INCONSISTENT;
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
        try {
            this._updateWatcher.workflowUpdated(workflowName, timestamp);
        }
        catch (Exception e) {
            String errorMessage = "Eror while notifying cluster about update of workflow '" + workflowName + "'." + ERROR_CLUSTER_INCONSISTENT;
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
    }

    public void deleteWorkflowDefinition(String workflowName) throws ProcessingException {
        this.checkWorkflowName(workflowName);
        AnyMap oldWorkflowAny = this._workflowStorage.getWorkflow(workflowName);
        this._workflowStorage.deleteWorkflow(workflowName);
        try {
            this._updateWatcher.workflowDeleted(workflowName);
        }
        catch (ProcessingException e) {
            String errorMessage = "Error deleting workflow '" + workflowName + "'.";
            this._log.warn((Object)(String.valueOf(errorMessage) + " Error while notifying update watcher."), (Throwable)e);
            try {
                if (oldWorkflowAny != null) {
                    this._workflowStorage.setWorkflow(workflowName, oldWorkflowAny);
                }
            }
            catch (ProcessingException e2) {
                errorMessage = String.valueOf(errorMessage) + ERROR_CLUSTER_INCONSISTENT;
                this._log.error((Object)(String.valueOf(errorMessage) + " Error rolling back deletion of workflow."), (Throwable)e2);
            }
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
        try {
            this._bpelEngine.undeployWorkflow(workflowName);
            this.unregisterPipeline(workflowName);
        }
        catch (ProcessingException e) {
            String errorMessage = "Error deleting workflow '" + workflowName + "'." + ERROR_CLUSTER_INCONSISTENT;
            this._log.error((Object)(String.valueOf(errorMessage) + " Error undeploying workflow."), (Throwable)e);
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
    }

    public void synchronizeWorkflowDefinition(String workflowName, boolean isDeleted) throws ProcessingException {
        this.checkWorkflowName(workflowName);
        AnyMap workflowDefinition = this._workflowStorage.getWorkflow(workflowName);
        if (isDeleted) {
            this._bpelEngine.undeployWorkflow(workflowName);
            this.unregisterPipeline(workflowName);
        } else {
            if (workflowDefinition == null) {
                throw new ProcessingException("Definition for workflow '" + workflowName + "' not found for reload.");
            }
            this._bpelEngine.deployWorkflow(workflowName, workflowDefinition);
            this.registerPipeline(workflowName);
        }
    }

    protected void activate() {
        this._lock.writeLock().lock();
        try {
            try {
                this._updateWatcher.registerProcessor(this);
                this.initializeBpel();
                this._updateWatcher.startPolling();
                this._updateWatcher.startWatching();
            }
            catch (Throwable ex) {
                this._log.error((Object)"Start of BPEL workflow service failed: Unknown fatal error. Service is non-functional, please fix problem and restart bundle", ex);
                this._lock.writeLock().unlock();
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected void deactivate() {
        this._lock.writeLock().lock();
        try {
            if (this._updateWatcher != null) {
                this._updateWatcher.stopPolling();
                this._updateWatcher.stopWatching();
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void setWorkflowStorage(WorkflowStorage workflowStorage) {
        this._workflowStorage = workflowStorage;
    }

    public void unsetWorkflowStorage(WorkflowStorage workflowStorage) {
        if (this._workflowStorage == workflowStorage) {
            this._workflowStorage = null;
        }
    }

    public void setUpdateWatcher(WorkflowUpdateWatcher updateWatcher) {
        this._updateWatcher = updateWatcher;
    }

    public void unsetUpdateWatcher(WorkflowUpdateWatcher updateWatcher) {
        if (this._updateWatcher == updateWatcher) {
            this._updateWatcher = null;
        }
    }

    public void setBpelEngine(BpelEngine bpelEngine) {
        this._bpelEngine = bpelEngine;
    }

    public void unsetBpelEngine(BpelEngine bpelEngine) {
        if (this._bpelEngine == bpelEngine) {
            this._bpelEngine = null;
        }
    }

    public void setRequestTable(RequestTable requests) {
        this._requests = requests;
    }

    public void unsetRequestTable(RequestTable requests) {
        if (this._requests == requests) {
            this._requests = null;
        }
    }

    private void initializeBpel() throws IOException, ODEServerException {
        this._log.debug((Object)"Initialize BPEL engine");
        try {
            this.deployPredefinedPipelines();
        }
        catch (ProcessingException ex) {
            this._log.error((Object)"Deployment of predefined pipelines failed. Installing custom pipelines should still work.", (Throwable)ex);
        }
        try {
            this.deployCustomPipelines();
        }
        catch (ProcessingException ex) {
            this._log.error((Object)"Deployment of existing custom pipelines failed. Installing additional custom pipelines should still work.", (Throwable)ex);
        }
        this._log.debug((Object)"Initialization of BPEL engine successful");
    }

    private void deployPredefinedPipelines() throws ProcessingException, IOException {
        String pipelineDir = ConfigurationHelper.getPipelineDirectory();
        Collection<String> workflowNames = this._bpelEngine.deployPredefinedWorkflows(pipelineDir);
        for (String workflowName : workflowNames) {
            this._log.info((Object)("Registering predefined pipeline " + workflowName));
            this.registerPipeline(workflowName);
        }
    }

    private void deployCustomPipelines() throws ProcessingException, IOException {
        Collection<String> workflowNames = this._workflowStorage.getWorkflowNames();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        for (String workflowName : workflowNames) {
            try {
                AnyMap workflowDefinition = this._workflowStorage.getWorkflow(workflowName);
                String timestamp = workflowDefinition.getStringValue("timestamp");
                this._bpelEngine.deployWorkflow(workflowName, workflowDefinition);
                this._updateWatcher.workflowLoadedOnStart(workflowName, timestamp);
                this._log.info((Object)("Registering custom pipeline " + workflowName));
                this.registerPipeline(workflowName);
            }
            catch (ProcessingException ex) {
                this._log.warn((Object)("Custom pipeline " + workflowName + " could not be deployed."), (Throwable)ex);
            }
        }
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    private void registerPipeline(String pipelineName) {
        this._pipelinePerformanceCounter.put(pipelineName, new PipelinePerformanceCounter(pipelineName));
        try {
            NameValidator.checkName((String)pipelineName);
            this._externalWorkflowNames.add(pipelineName);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Pipeline name '" + pipelineName + "' is not valid and will not be accessible for external calls: " + ex.getMessage()));
        }
    }

    private void unregisterPipeline(String pipelineName) {
        this._pipelinePerformanceCounter.remove(pipelineName);
        this._externalWorkflowNames.remove(pipelineName);
    }

    private void checkWorkflowName(String workflowName) throws ProcessingException {
        try {
            NameValidator.checkName((String)workflowName);
        }
        catch (Exception ex) {
            throw new ProcessingException("Workflow name '" + workflowName + "' is not valid: " + ex.getMessage());
        }
        if (this._bpelEngine.isPredefinedWorkflow(workflowName)) {
            throw new ProcessingException("Workflow '" + workflowName + "' can not be changed, cause it's predefined");
        }
    }

    private String setTimestamp(AnyMap workflowDefinition) {
        Value value = workflowDefinition.getFactory().createDateTimeValue(new Date());
        workflowDefinition.put("timestamp", (Any)value);
        return value.asString();
    }

    private void countInvocation(String[] incomingIds, String[] outgoingIds, long startTime, boolean success, PipelinePerformanceCounter counter) {
        if (counter != null) {
            counter.countInvocationNanos(System.nanoTime() - startTime, success, ArrayUtils.getLength((Object)incomingIds), ArrayUtils.getLength((Object)outgoingIds));
        }
    }

    private void countError(Throwable ex, boolean isCritical, PipelinePerformanceCounter counter) {
        if (counter != null) {
            counter.addError(ex, isCritical);
        }
    }
}

