/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.solr.search.FilterGroup;
import org.eclipse.smila.solr.search.SolrQueryParameterAccessor;
import org.eclipse.smila.solr.util.SolrQueryUtils;

public class SolrQueryConverter {
    private static final String SOLR_LOCAL_PARAMS_OPERATOR = "o.op";
    private static final String SMILA_RANKING_PARAMETER_OPERATOR = "Operator";
    protected final Log _log = LogFactory.getLog(this.getClass());
    private final Map<String, FilterGroup> _filterGroups;
    private transient StringBuilder _buffer = new StringBuilder(4095);
    private final SolrQueryParameterAccessor _accessor;
    private final SolrQuery _solrQuery = new SolrQuery();

    public SolrQueryConverter(SolrQueryParameterAccessor accessor) {
        this._accessor = accessor;
        this._filterGroups = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

            public Object create() {
                return new FilterGroup();
            }
        });
    }

    public SolrQuery toSolrQuery(List<String> schemaAttributes) {
        String qt = this._accessor.getRequestHandler();
        this._solrQuery.setQueryType(qt);
        this.doQuery(schemaAttributes);
        this.doSortOrder();
        this.doTermsSettings();
        this.doSmilaFilters();
        this.doFacetSettings();
        this.doFilterGroups();
        this.doGroupSettings();
        if (this._solrQuery.getQuery() != null || this._solrQuery.getFields() != null) {
            this.doQuerySettings();
            this.doHighlightingSettings();
            this.doShardsSettings();
            this.doSpellCheckSettings();
            this.doMoreLikeThis();
        }
        AnyMap map = this._accessor.getSolrQueryParams().getMap("nativeParameters");
        this.addAsSolrParameters(map);
        return this._solrQuery;
    }

    private void doQuery(List<String> schemaAttributes) {
        Value value;
        Any ranking;
        String q = this._accessor.getQuery();
        if (StringUtils.isNotEmpty((String)q)) {
            this._filterGroups.get((Object)"q").filterStrings.add(q);
        } else if (schemaAttributes != null && !schemaAttributes.isEmpty()) {
            StringBuilder fieldQuery = this.resetBuffer();
            for (String field : schemaAttributes) {
                List fieldQueryValues = this._accessor.getQueryAttributeValues(field);
                if (fieldQueryValues == null) continue;
                SolrQueryUtils.appendFieldQueryPart(fieldQuery, field, fieldQueryValues);
            }
            String fq = fieldQuery.toString().trim();
            if (StringUtils.isNotEmpty((String)fq)) {
                this._filterGroups.get((Object)"q").filterStrings.add(fq);
            }
        }
        if (this._filterGroups.containsKey("q") && (ranking = this._accessor.getRankingConfig()) != null && (value = ranking.asMap().getValue(SMILA_RANKING_PARAMETER_OPERATOR)) != null) {
            this._filterGroups.get((Object)"q").localParams.put(SOLR_LOCAL_PARAMS_OPERATOR, (Any)value);
        }
    }

    private void doQuerySettings() {
        int start = this._accessor.getOffset();
        this._solrQuery.setStart(Integer.valueOf(start));
        int rows = this._accessor.getMaxCount();
        this._solrQuery.setRows(Integer.valueOf(rows));
        String[] fl = this._accessor.getResultAttributes().toArray(new String[this._accessor.getResultAttributes().size()]);
        this._solrQuery.setFields(fl);
        this._solrQuery.addField("score");
        this._solrQuery.addField("_recordid");
    }

    private void doSortOrder() {
        List annotations = this._accessor.getSubParameters("sortby");
        if (annotations != null) {
            for (AnyMap annotation : annotations) {
                String attributeName = annotation.getStringValue("attribute");
                String orderModeValue = annotation.getStringValue("order");
                if (StringUtils.startsWith((String)orderModeValue, (String)"asc")) {
                    this._solrQuery.addSortField(attributeName, SolrQuery.ORDER.asc);
                    continue;
                }
                this._solrQuery.addSortField(attributeName, SolrQuery.ORDER.desc);
            }
        }
    }

    private void doFilterGroups() {
        for (Map.Entry<String, FilterGroup> entry : this._filterGroups.entrySet()) {
            FilterGroup filterGroup = entry.getValue();
            String groupName = entry.getKey();
            StringBuilder fq = this.resetBuffer();
            this.appendLocalParams(fq, this._accessor.getFilterLocalParams(groupName, false), filterGroup.localParams);
            switch (filterGroup.filterStrings.size()) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    fq.append(filterGroup.filterStrings.get(0));
                    break;
                }
                default: {
                    for (String part : filterGroup.filterStrings) {
                        if ("*:*".equals(part) || StringUtils.isBlank((String)part)) continue;
                        fq.append("+(");
                        fq.append(part);
                        fq.append(")");
                    }
                }
            }
            String solrQueryString = fq.toString();
            if ("q".equals(groupName)) {
                this._solrQuery.setQuery(solrQueryString);
            } else {
                this._solrQuery.addFilterQuery(new String[]{solrQueryString});
            }
            if (!this._log.isTraceEnabled()) continue;
            this._log.trace((Object)String.format("adding filter group: %s=%s", groupName, solrQueryString));
        }
        this.addFilterSolrSyntax();
    }

    private void doSmilaFilters() {
        if (!this._accessor.hasFilters()) {
            return;
        }
        List filters = this._accessor.getSubParameters("filter");
        int filterConfigIndex = 0;
        while (filterConfigIndex < filters.size()) {
            AnyMap filterConfig = (AnyMap)filters.get(filterConfigIndex);
            String attribute = filterConfig.getStringValue("attribute");
            if (StringUtils.isEmpty((String)attribute)) {
                String msg = MessageFormat.format("Skip filter configuration at index: {0}. No attribute defined", filterConfigIndex);
                this._log.warn((Object)msg);
            } else {
                String groupName = StringUtils.defaultString((String)filterConfig.getStringValue("filterGroup"), (String)attribute);
                StringBuilder fq = this.resetBuffer();
                this.addFilterSmilaSyntax(fq, attribute, filterConfig, filterConfigIndex);
                this._filterGroups.get((Object)groupName).filterStrings.add(fq.toString());
            }
            ++filterConfigIndex;
        }
    }

    private void addFilterSmilaSyntax(StringBuilder fq, String attribute, AnyMap filter, int index) {
        for (Map.Entry condition : filter.entrySet()) {
            String value;
            AnySeq values;
            String filterType = (String)condition.getKey();
            if ("attribute".equals(filterType) || "filterGroup".equals(filterType)) continue;
            if ("oneOf".equals(filterType)) {
                values = ((Any)condition.getValue()).asSeq();
                this.appendFilterSetExpression(fq, attribute, values, "");
            } else if ("allOf".equals(filterType)) {
                values = ((Any)condition.getValue()).asSeq();
                this.appendFilterSetExpression(fq, attribute, values, "+");
            } else if ("noneOf".equals(filterType)) {
                values = ((Any)condition.getValue()).asSeq();
                this.appendFilterSetExpression(fq, attribute, values, "-");
            } else if ("atLeast".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.appendFilterRangeExpression(fq, attribute, value, "*", false);
            } else if ("greaterThan".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.appendFilterRangeExpression(fq, attribute, value, "*", true);
            } else if ("atMost".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.appendFilterRangeExpression(fq, attribute, "*", value, false);
            } else if ("lessThan".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.appendFilterRangeExpression(fq, attribute, "*", value, true);
            } else {
                this._log.warn((Object)String.format("unknown (filter) element in filters encountered on attribute %s: %s[%s]. It is ignored.", attribute, filterType, index));
            }
            if (fq.length() == 0) {
                this._log.warn((Object)String.format("Filter on attribute %s: %s[%d] has no values and is ignored!", attribute, filterType, index));
                continue;
            }
            String fqString = fq.toString();
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)String.format("Filter converted from Smila Syntax on attribute %s: %s[%d]: %s", attribute, filterType, index, fqString));
        }
    }

    private void appendFilterRangeExpression(StringBuilder fq, String attribute, String lower, String upper, boolean exclusive) {
        if (StringUtils.isBlank((String)lower)) {
            throw new IllegalArgumentException("lower bound must not be blank");
        }
        if (StringUtils.isBlank((String)upper)) {
            throw new IllegalArgumentException("upper bound must not be blank");
        }
        lower = this.appendFilterRangeExpressionBoundExclusionIfNotStar(fq, attribute, lower, exclusive);
        upper = this.appendFilterRangeExpressionBoundExclusionIfNotStar(fq, attribute, upper, exclusive);
        fq.append(" +(");
        fq.append(attribute);
        fq.append(":[");
        fq.append(lower);
        fq.append(" TO ");
        fq.append(upper);
        fq.append("])");
    }

    private String appendFilterRangeExpressionBoundExclusionIfNotStar(StringBuilder fq, String attribute, String value, boolean exclusive) {
        if (!"*".equals(value)) {
            value = SolrQueryUtils.escapeQuery(value, "+-&|!(){}[]^~*?:\\\" ");
            if (exclusive) {
                fq.append(" -(");
                fq.append(attribute);
                fq.append(":");
                fq.append(value);
                fq.append(")");
            }
        }
        return value;
    }

    private void appendFilterSetExpression(StringBuilder fq, String attribute, AnySeq values, String operator) {
        List filterValues;
        try {
            filterValues = values.asStrings();
        }
        catch (InvalidValueTypeException e) {
            throw new InvalidValueTypeException("Filter Syntax Error: Filter must be of Type Seq and contain only Val elements.", (Exception)((Object)e));
        }
        for (String filterValue : filterValues) {
            String filterValueEscaped = SolrQueryUtils.escapeQuery(filterValue, "+-&|!(){}[]^~*?:\\\" ");
            fq.append(operator);
            fq.append("(");
            fq.append(attribute);
            fq.append(":");
            fq.append(filterValueEscaped);
            fq.append(")");
        }
    }

    private void addFilterSolrSyntax() {
        AnySeq filterQueries = this._accessor.getFilterQuery();
        if (filterQueries != null && filterQueries.size() > 0) {
            String[] fq = filterQueries.asStrings().toArray(new String[filterQueries.size()]);
            this._solrQuery.setFilterQueries(fq);
        }
    }

    private void doFacetSettings() {
        List facetByConfigs = this._accessor.getFacetByConfig();
        if (facetByConfigs.isEmpty()) {
            return;
        }
        this._solrQuery.add("facet", new String[]{"true"});
        int facetByIndex = 0;
        for (AnyMap facetConfig : facetByConfigs) {
            AnyMap sortby;
            String filterGroupName;
            ++facetByIndex;
            String attribute = facetConfig.getStringValue("attribute");
            if (attribute == null) {
                this._log.warn((Object)MessageFormat.format("no attribute defined for facet @ index: {0}. It is ignored.", facetByIndex));
                continue;
            }
            String fieldName = attribute;
            String facetType = StringUtils.defaultString((String)facetConfig.getStringValue("type"), (String)"facet.field");
            String facetName = StringUtils.defaultString((String)facetConfig.getStringValue("facetName"), (String)attribute);
            boolean multiselect = BooleanUtils.isTrue((Boolean)facetConfig.getBooleanValue("multiselect"));
            if (facetType.equals("custom.ranges")) {
                this.addCustomRangesFacet(fieldName, facetName, multiselect, facetConfig);
                continue;
            }
            AnyMap localParams = facetConfig.getMap("localParams", true);
            if (!facetName.equals(attribute)) {
                localParams.put("key", facetName);
            }
            if (multiselect) {
                filterGroupName = "facet_" + facetName;
                localParams.put("ex", filterGroupName);
            } else {
                filterGroupName = StringUtils.defaultString((String)facetConfig.getStringValue("filterGroup"), (String)("facet_" + facetName));
            }
            StringBuilder facetParam = this.resetBuffer();
            this.appendLocalParams(facetParam, localParams);
            facetParam.append(fieldName);
            this._solrQuery.add(facetType, new String[]{facetParam.toString()});
            String maxCount = facetConfig.getStringValue("maxcount");
            if (maxCount != null) {
                this.addFieldParameter(fieldName, "facet.limit", maxCount);
            }
            if ((sortby = facetConfig.getMap("sortby")) != null) {
                String criterion = sortby.getStringValue("criterion");
                this.addFieldParameter(fieldName, "facet.sort", criterion);
                if (this._log.isWarnEnabled() && sortby.containsKey((Object)"order")) {
                    this._log.warn((Object)String.format("facet config for field %s contains value for unsupported sort order. It is ignored", fieldName));
                }
            }
            AnyMap map = facetConfig.getMap("nativeParameters");
            this.addAsSolrParameters(map, fieldName);
            AnySeq filterConfig = facetConfig.getSeq("oneOf");
            if (filterConfig == null) continue;
            StringBuilder fq = this.resetBuffer();
            this.appendFilterSetExpression(fq, attribute, filterConfig, "");
            if (fq.length() <= 0) continue;
            FilterGroup filterGroup = this._filterGroups.get(filterGroupName);
            filterGroup.filterStrings.add(fq.toString());
            filterGroup.localParams.put("tag", filterGroupName);
        }
    }

    private void addCustomRangesFacet(String attribute, String facetName, Boolean multiselect, AnyMap facetConfig) {
        AnySeq ranges = facetConfig.getSeq("ranges");
        if (ranges == null) {
            return;
        }
        int position = 0;
        for (Any range : ranges) {
            StringBuilder facetQuery = new StringBuilder();
            String ex = "";
            if (multiselect.booleanValue()) {
                ex = " ex=facet_" + facetName;
            }
            facetQuery.append("{!key=");
            facetQuery.append(facetName);
            facetQuery.append("_");
            facetQuery.append(position);
            facetQuery.append(ex);
            facetQuery.append("}");
            facetQuery.append(attribute);
            facetQuery.append(":");
            facetQuery.append(range.asValue().asString());
            ++position;
            this._solrQuery.addFacetQuery(facetQuery.toString());
        }
        AnySeq oneOf = facetConfig.getSeq("oneOf");
        if (oneOf != null) {
            StringBuilder filterQuery = new StringBuilder();
            if (multiselect.booleanValue()) {
                filterQuery.append("{!tag=facet_" + facetName + "}");
            }
            for (Any filter : oneOf) {
                try {
                    String filterReferenze = filter.asValue().asString();
                    String[] split = StringUtils.split((String)filterReferenze, (String)"_");
                    int index = NumberUtils.toInt((String)split[split.length - 1]);
                    String resolvedFilter = ranges.getStringValue(index);
                    filterQuery.append("");
                    filterQuery.append("(");
                    filterQuery.append(attribute);
                    filterQuery.append(":");
                    filterQuery.append(resolvedFilter);
                    filterQuery.append(")");
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("custom range filter cannot be resolved: %s oneOf %s", facetName, filter.asValue().asString()), e);
                }
            }
            this._solrQuery.addFilterQuery(new String[]{filterQuery.toString()});
        }
    }

    private StringBuilder resetBuffer() {
        this._buffer.setLength(0);
        return this._buffer;
    }

    private StringBuilder appendLocalParams(StringBuilder sb, AnyMap ... localParams) {
        int originalLength = sb.length();
        if (localParams != null) {
            sb.append("{!");
            AnyMap[] anyMapArray = localParams;
            int n = localParams.length;
            int n2 = 0;
            while (n2 < n) {
                AnyMap anyMap = anyMapArray[n2];
                if (!MapUtils.isEmpty((Map)anyMap)) {
                    for (Map.Entry localParam : anyMap.entrySet()) {
                        this.appendLocalParam(sb, (String)localParam.getKey(), (Any)localParam.getValue());
                    }
                }
                ++n2;
            }
            if (sb.length() == originalLength + 2) {
                sb.setLength(originalLength);
            } else {
                sb.setCharAt(sb.length() - 1, '}');
            }
        }
        return sb;
    }

    private void appendLocalParam(StringBuilder sb, String name, Any value) {
        sb.append(name);
        String stringValue = value.asValue().asString();
        if (StringUtils.isNotBlank((String)stringValue)) {
            sb.append("=");
            sb.append(stringValue);
        }
        sb.append(" ");
    }

    private void doTermsSettings() {
        AnyMap terms = this._accessor.getTerms();
        if (terms != null) {
            this._solrQuery.setParam("qt", new String[]{"/terms"});
            this.addAsSolrParameters(terms);
        }
    }

    private void doHighlightingSettings() {
        if (this._accessor.hasHighlightConfig()) {
            for (Any config : this._accessor.getHighlightConfig()) {
                if (!config.isMap()) continue;
                AnyMap highlight = config.asMap();
                String fieldName = highlight.getStringValue("attribute");
                this._solrQuery.addHighlightField(fieldName);
                AnyMap nativeParameters = highlight.getMap("nativeParameters");
                this.addAsSolrParameters(nativeParameters, fieldName);
            }
        }
    }

    private void addAsSolrParameters(AnyMap map, String field) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("attribute")) continue;
            String value = ((Any)entry.getValue()).asValue().asString();
            if (StringUtils.isBlank((String)field)) {
                this._solrQuery.add(key, new String[]{value});
                continue;
            }
            this.addFieldParameter(field, key, value);
        }
    }

    private void addAsSolrParameters(AnyMap map) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Any value = (Any)entry.getValue();
            if (value.isSeq()) {
                AnySeq values = value.asSeq();
                for (Any any : values) {
                    this._solrQuery.add(key, new String[]{any.asValue().asString()});
                }
                continue;
            }
            if (!value.isValue()) continue;
            String single = value.asValue().asString();
            this._solrQuery.add(key, new String[]{single});
        }
    }

    private void addFieldParameter(String field, String paramName, String value) {
        String parmName = "f." + field + "." + paramName;
        this._solrQuery.add(parmName, new String[]{value});
    }

    private void doShardsSettings() {
        AnySeq seq = this._accessor.getShards();
        if (seq != null) {
            String shards = StringUtils.join((Collection)seq.asStrings(), (String)",");
            this._solrQuery.setParam("shards", new String[]{shards});
        }
    }

    private void doSpellCheckSettings() {
        AnyMap spellcheck = this._accessor.getSpellcheck();
        if (spellcheck != null) {
            this.addAsSolrParameters(spellcheck);
        }
    }

    private void doMoreLikeThis() {
        AnyMap moreLikeThis = this._accessor.getMoreLikeThis();
        if (moreLikeThis != null) {
            this.addAsSolrParameters(moreLikeThis);
        }
    }

    private void doGroupSettings() {
        if (this._accessor.hasGroupbyConfig()) {
            AnySeq method = null;
            String asMainResult = null;
            for (Map.Entry entry : this._accessor.getGroupbyConfig().entrySet()) {
                String key = (String)entry.getKey();
                Any any = (Any)entry.getValue();
                if (any.isSeq()) {
                    if (!key.equals("attributes")) continue;
                    method = any.asSeq();
                    continue;
                }
                if (any.isMap()) {
                    method = any.asMap().getSeq("attributes");
                    continue;
                }
                if (!any.isValue() || !key.equals("asMainResult")) continue;
                asMainResult = any.asValue().asString();
            }
            if (method == null) {
                throw new NullArgumentException("groupby method AnySeq");
            }
            AnyMap groupby = method.getMap(0);
            if (groupby != null) {
                this._solrQuery.add("group", new String[]{"true"});
                String attribute = groupby.getStringValue("attribute");
                if (StringUtils.isEmpty((String)attribute)) {
                    throw new NullArgumentException("attribute");
                }
                this._solrQuery.add("group.field", new String[]{attribute});
                Long maxcount = groupby.getLongValue("maxcount");
                if (maxcount != null) {
                    this._solrQuery.add("group.limit", new String[]{String.valueOf(maxcount)});
                }
                if (StringUtils.isNotEmpty((String)asMainResult)) {
                    this._solrQuery.add("group.main", new String[]{"true"});
                }
            }
        }
    }
}

