/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetXACallInfo;

public class NetXAConnectionRequest
extends NetResultSetRequest {
    NetXAConnectionRequest(NetAgent netAgent, CcsidManager ccsidManager, int bufferSize) {
        super(netAgent, ccsidManager, bufferSize);
    }

    public void writeLocalXACommit(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        this.buildSYNCCTLMigrate();
        this.buildSYNCCTLCommit(0x10000000, xid);
    }

    public void writeLocalXARollback(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        this.buildSYNCCTLRollback(0x10000000);
    }

    public void writeXaStartUnitOfWork(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        int xaFlags = callInfo.xaFlags_;
        long xaTimeout = callInfo.xaTimeoutMillis_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 9);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        if (xaTimeout >= 0L) {
            this.writeXATimeout(6407, xaTimeout);
        }
        this.updateLengthBytes();
    }

    public void writeXaEndUnitOfWork(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        int xaFlags = callInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 11);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    protected void writeXaPrepare(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        int xaFlags = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 1);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    protected void writeXaCommit(NetConnection conn, Xid xid) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        int xaFlags = callInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    protected void writeXaRollback(NetConnection conn, Xid xid) throws SqlException {
        int xaFlags = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    protected void writeXaRecover(NetConnection conn, int flag) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 12);
        this.writeXAFlags(6403, flag);
        this.updateLengthBytes();
    }

    protected void writeXaForget(NetConnection conn, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 6);
        this.writeXID(6145, xid);
        this.updateLengthBytes();
    }

    public void writeSYNCType(int codepoint, int syncType) {
        this.writeScalar1Byte(codepoint, syncType);
    }

    public void writeForget(int codepoint, int value) {
        this.writeScalar1Byte(codepoint, value);
    }

    public void writeReleaseConversation(int codepoint, int value) {
        this.writeScalar1Byte(codepoint, value);
    }

    void writeNullXID(int codepoint) {
        int nullXID = -1;
        this.writeScalar4Bytes(codepoint, nullXID);
    }

    void writeXID(int codepoint, Xid xid) throws SqlException {
        int len = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        this.markLengthBytes(codepoint);
        len = 4;
        len += bqual.length + 4;
        len += gtrid.length + 4;
        this.write4Bytes(formatId);
        this.write4Bytes(gtrid.length);
        this.write4Bytes(bqual.length);
        this.ensureLength(this.offset_ + gtrid.length);
        System.arraycopy(gtrid, 0, this.bytes_, this.offset_, gtrid.length);
        this.offset_ += gtrid.length;
        this.ensureLength(this.offset_ + bqual.length);
        System.arraycopy(bqual, 0, this.bytes_, this.offset_, bqual.length);
        this.offset_ += bqual.length;
        this.updateLengthBytes();
    }

    void writeXAFlags(int codepoint, int xaFlags) {
        this.writeScalar4Bytes(codepoint, xaFlags);
    }

    void writeXATimeout(int codepoint, long xaTimeout) {
        this.writeScalar8Bytes(codepoint, xaTimeout);
    }

    void buildSYNCCTLMigrate() throws SqlException {
    }

    void buildSYNCCTLCommit(int xaFlags, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    void buildSYNCCTLRollback(int xaFlags) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        this.writeNullXID(6145);
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }
}

