/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.SqlXmlUtil;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.XMLDataValue;

public class XML
extends DataType
implements XMLDataValue,
StreamStorable {
    protected static final short UTF8_IMPL_ID = 0;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(XML.class);
    public static final short XQ_PASS_BY_REF = 1;
    public static final short XQ_PASS_BY_VALUE = 2;
    public static final short XQ_RETURN_SEQUENCE = 3;
    public static final short XQ_RETURN_CONTENT = 4;
    public static final short XQ_EMPTY_ON_EMPTY = 5;
    public static final short XQ_NULL_ON_EMPTY = 6;
    public static final int XML_DOC_ANY = 0;
    public static final int XML_SEQUENCE = 1;
    private int xType;
    private SQLChar xmlStringValue;
    private static String xmlReqCheck = null;
    private boolean containsTopLevelAttr;
    private SqlXmlUtil tmpUtil;

    public XML() {
        this.xmlStringValue = null;
        this.xType = -1;
        this.containsTopLevelAttr = false;
    }

    private XML(SQLChar val, int xmlType, boolean seqWithAttr) {
        this.xmlStringValue = val == null ? null : (SQLChar)val.getClone();
        this.setXType(xmlType);
        if (seqWithAttr) {
            this.markAsHavingTopLevelAttr();
        }
    }

    public DataValueDescriptor getClone() {
        return new XML(this.xmlStringValue, this.getXType(), this.hasTopLevelAttr());
    }

    public DataValueDescriptor getNewNull() {
        return new XML();
    }

    public String getTypeName() {
        return "XML";
    }

    public int typePrecedence() {
        return 180;
    }

    public String getString() throws StandardException {
        return this.xmlStringValue == null ? null : this.xmlStringValue.getString();
    }

    public int getLength() throws StandardException {
        return this.xmlStringValue == null ? 0 : this.xmlStringValue.getLength();
    }

    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (this.xmlStringValue != null) {
            sz += this.xmlStringValue.estimateMemoryUsage();
        }
        return sz;
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        in.readShort();
        this.xmlStringValue.readExternalFromArray(in);
        this.setXType(0);
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        String strVal = theValue.getString();
        if (strVal == null) {
            this.xmlStringValue = null;
            this.setXType(0);
            return;
        }
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(strVal);
        if (theValue instanceof XMLDataValue) {
            this.setXType(((XMLDataValue)theValue).getXType());
            if (((XMLDataValue)theValue).hasTopLevelAttr()) {
                this.markAsHavingTopLevelAttr();
            }
        }
    }

    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        String valAsStr = resultSet.getString(colNumber);
        if (this.tmpUtil == null) {
            try {
                this.tmpUtil = new SqlXmlUtil();
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Failed to instantiate SqlXmlUtil for XML parsing.");
                this.xmlStringValue.setValue(valAsStr);
                this.setXType(-1);
                return;
            }
        }
        try {
            valAsStr = this.tmpUtil.serializeToString(valAsStr);
            this.xmlStringValue.setValue(valAsStr);
            this.setXType(0);
        }
        catch (Throwable t) {
            this.xmlStringValue.setValue(valAsStr);
            this.setXType(-1);
        }
    }

    public int compare(DataValueDescriptor other) throws StandardException {
        SanityManager.ASSERT(other instanceof XMLDataValue, "Store should NOT have tried to compare an XML value with a non-XML value.");
        if (this.isNull()) {
            if (other.isNull()) {
                return 0;
            }
            return -1;
        }
        if (other.isNull()) {
            return 1;
        }
        SanityManager.THROWASSERT("Store tried to compare two non-null XML values, which isn't allowed.");
        return 0;
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        SanityManager.ASSERT(source instanceof XMLDataValue, "Tried to store non-XML value into XML column; should have thrown error at compile time.");
        if (((XMLDataValue)source).getXType() != 0) {
            throw StandardException.newException("2200L");
        }
        this.setValue(source);
    }

    public int getTypeFormatId() {
        return 458;
    }

    public boolean isNull() {
        return this.xmlStringValue == null || this.xmlStringValue.isNull();
    }

    public void restoreToNull() {
        if (this.xmlStringValue != null) {
            this.xmlStringValue.restoreToNull();
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        in.readShort();
        this.xmlStringValue.readExternal(in);
        this.setXType(0);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeShort(0);
        this.xmlStringValue.writeExternal(out);
    }

    public InputStream returnStream() {
        return this.xmlStringValue == null ? null : this.xmlStringValue.returnStream();
    }

    public void setStream(InputStream newStream) {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        try {
            newStream.read();
            newStream.read();
        }
        catch (Exception e) {
            SanityManager.THROWASSERT("Failed to read impl idbytes in setStream.");
        }
        this.xmlStringValue.setStream(newStream);
        this.setXType(0);
    }

    public void loadStream() throws StandardException {
        this.getString();
    }

    public XMLDataValue XMLParse(String text, boolean preserveWS, SqlXmlUtil sqlxUtil) throws StandardException {
        try {
            if (preserveWS) {
                text = sqlxUtil.serializeToString(text);
            } else {
                SanityManager.THROWASSERT("Tried to STRIP whitespace but we shouldn't have made it this far");
            }
        }
        catch (Throwable t) {
            throw StandardException.newException("2200M", t, (Object)t.getMessage());
        }
        this.setXType(0);
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(text);
        return this;
    }

    public StringDataValue XMLSerialize(StringDataValue result, int targetType, int targetWidth, int targetCollationType) throws StandardException {
        if (result == null) {
            switch (targetType) {
                case 1: {
                    result = new SQLChar();
                    break;
                }
                case 12: {
                    result = new SQLVarchar();
                    break;
                }
                case -1: {
                    result = new SQLLongvarchar();
                    break;
                }
                case 2005: {
                    result = new SQLClob();
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("Should NOT have made it to XMLSerialize with a non-string target type: " + targetType);
                    return null;
                }
            }
            if (result instanceof StringDataValue) {
                try {
                    RuleBasedCollator rbs = ConnectionUtil.getCurrentLCC().getDataValueFactory().getCharacterCollator(targetCollationType);
                    result = result.getValue(rbs);
                }
                catch (SQLException sqle) {
                    throw StandardException.plainWrapException(sqle);
                }
            }
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        if (this.hasTopLevelAttr()) {
            throw StandardException.newException("2200W");
        }
        result.setValue(this.getString());
        result.setWidth(targetWidth, 0, true);
        return result;
    }

    public BooleanDataValue XMLExists(SqlXmlUtil sqlxUtil) throws StandardException {
        if (this.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        SanityManager.ASSERT(sqlxUtil != null, "Tried to evaluate XML xquery, but no XML objects were loaded.");
        try {
            return new SQLBoolean(null != sqlxUtil.evalXQExpression(this, false, new int[1]));
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable xe) {
            throw StandardException.newException("10000", xe, (Object)"XMLEXISTS", (Object)xe.getMessage());
        }
    }

    public XMLDataValue XMLQuery(XMLDataValue result, SqlXmlUtil sqlxUtil) throws StandardException {
        if (this.isNull()) {
            if (result == null) {
                result = (XMLDataValue)this.getNewNull();
            } else {
                result.setToNull();
            }
            return result;
        }
        try {
            int[] xType = new int[1];
            ArrayList itemRefs = sqlxUtil.evalXQExpression(this, true, xType);
            if (result == null) {
                result = new XML();
            }
            String strResult = sqlxUtil.serializeToString(itemRefs, result);
            result.setValue(new SQLChar(strResult));
            result.setXType(xType[0]);
            return result;
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable xe) {
            throw StandardException.newException("10000", xe, (Object)"XMLQUERY", (Object)xe.getMessage());
        }
    }

    public void setXType(int xtype) {
        this.xType = xtype;
        if (xtype == 0) {
            this.containsTopLevelAttr = false;
        }
    }

    public int getXType() {
        return this.xType;
    }

    public void markAsHavingTopLevelAttr() {
        this.containsTopLevelAttr = true;
    }

    public boolean hasTopLevelAttr() {
        return this.containsTopLevelAttr;
    }

    public static void checkXMLRequirements() throws StandardException {
        if (xmlReqCheck == null) {
            xmlReqCheck = "";
            if (!ClassInspector.classIsLoadable("org.w3c.dom.Document")) {
                xmlReqCheck = "JAXP";
            } else if (!ClassInspector.classIsLoadable("org.apache.xpath.XPath")) {
                xmlReqCheck = "Xalan";
            }
        }
        if (xmlReqCheck.length() != 0) {
            throw StandardException.newException("XML00", xmlReqCheck);
        }
    }
}

