/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.MemBackedMessageImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MessageExchangeImpl
implements MessageExchange {
    static final String WSDL2_EXTENSIONS_NS = "http://www.w3.org/ns/wsdl-extensions";
    static final QName SAFE_ATTRIBUTE = new QName("http://www.w3.org/ns/wsdl-extensions", "safe");
    private static final Log __log = LogFactory.getLog(MessageExchangeImpl.class);
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    final Contexts _contexts;
    final ODEProcess _process;
    final PartnerLinkModel _oplink;
    final String _mexId;
    final PortType _portType;
    final Operation _operation;
    Long _iid;
    EndpointReference _epr;
    MessageImpl _request;
    long _timeout = 30000L;
    private volatile MessageExchange.Status _status = MessageExchange.Status.NEW;
    volatile QName _fault;
    volatile String _explanation;
    volatile MessageImpl _response;
    private volatile int _syncdummy;
    final HashSet<Change> _changes = new HashSet();
    final HashMap<String, String> _properties = new HashMap();
    final HashSet<String> _loadedProperties = new HashSet();
    final HashSet<String> _modifiedProperties = new HashSet();
    protected MessageExchange.FailureType _failureType;
    private Set<String> _propNames;
    private MessageExchange.AckType _ackType;

    public MessageExchangeImpl(ODEProcess oDEProcess, Long l, String string, PartnerLinkModel partnerLinkModel, PortType portType, Operation operation) {
        this._process = oDEProcess;
        this._contexts = oDEProcess._contexts;
        this._mexId = string;
        this._iid = l;
        this._oplink = partnerLinkModel;
        this._portType = portType;
        this._operation = operation;
    }

    public boolean equals(Object object) {
        return this._mexId.equals(((MessageExchangeImpl)object)._mexId);
    }

    Long getIID() {
        return this._iid;
    }

    void load(MessageExchangeDAO messageExchangeDAO) {
        this._timeout = messageExchangeDAO.getTimeout();
        this._iid = messageExchangeDAO.getInstance() != null ? messageExchangeDAO.getInstance().getInstanceId() : null;
        this._ackType = messageExchangeDAO.getAckType();
        this._status = messageExchangeDAO.getStatus();
        this._fault = messageExchangeDAO.getFault();
        this._explanation = messageExchangeDAO.getFaultExplanation();
    }

    void save(MessageExchangeDAO messageExchangeDAO) {
        messageExchangeDAO.setPartnerLinkModelId(this._oplink.getId());
        messageExchangeDAO.setOperation(this._operation.getName());
        messageExchangeDAO.setStatus(this._status);
        messageExchangeDAO.setInvocationStyle(this.getInvocationStyle());
        messageExchangeDAO.setFault(this._fault);
        messageExchangeDAO.setFaultExplanation(this._explanation);
        messageExchangeDAO.setTimeout(this._timeout);
        messageExchangeDAO.setFailureType(this._failureType);
        messageExchangeDAO.setAckType(this._ackType);
        if (this._changes.contains((Object)Change.EPR)) {
            this._changes.remove((Object)Change.EPR);
            if (this._epr != null) {
                messageExchangeDAO.setEPR(this._epr.toXML().getDocumentElement());
            } else {
                messageExchangeDAO.setEPR(null);
            }
        }
        for (String string : this._modifiedProperties) {
            messageExchangeDAO.setProperty(string, this._properties.get(string));
        }
        this._modifiedProperties.clear();
    }

    void save() {
        this.doInTX(new InDbAction<Void>(){

            @Override
            public Void call(MessageExchangeDAO messageExchangeDAO) {
                MessageExchangeImpl.this.save(messageExchangeDAO);
                return null;
            }
        });
    }

    public abstract InvocationStyle getInvocationStyle();

    public boolean isSafe() {
        Object object = this.getOperation().getExtensionAttribute(SAFE_ATTRIBUTE);
        if (object == null) {
            return false;
        }
        try {
            return Boolean.valueOf(object.toString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getMessageExchangeId() throws BpelEngineException {
        return this._mexId;
    }

    public String getOperationName() throws BpelEngineException {
        return this.getOperation().getName();
    }

    public MessageExchange.MessageExchangePattern getMessageExchangePattern() {
        return this._operation.getOutput() == null ? MessageExchange.MessageExchangePattern.REQUEST_ONLY : MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
    }

    public boolean isTransactional() throws BpelEngineException {
        switch (this.getInvocationStyle()) {
            case TRANSACTED: 
            case RELIABLE: {
                return true;
            }
        }
        return false;
    }

    public QName getFault() {
        return this._fault;
    }

    public Message getFaultResponse() {
        return this._fault == null ? null : this.getResponse();
    }

    public String getFaultExplanation() {
        return this._explanation;
    }

    public MessageExchange.Status getStatus() {
        return this._status;
    }

    public MessageExchange.AckType getAckType() {
        return this._ackType;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public PortType getPortType() {
        return this._portType;
    }

    public Message getRequest() {
        if (this._request != null) {
            return this._request;
        }
        this._request = this.doInTX(new InDbAction<MessageImpl>(){

            @Override
            public MessageImpl call(MessageExchangeDAO messageExchangeDAO) {
                MessageDAO messageDAO = messageExchangeDAO.getRequest();
                if (messageDAO == null) {
                    return null;
                }
                return new MemBackedMessageImpl(messageDAO.getHeader(), messageDAO.getData(), messageDAO.getType(), true);
            }
        });
        return this._request;
    }

    public Message getResponse() {
        if (this._response != null) {
            return this._response;
        }
        this._response = this.doInTX(new InDbAction<MessageImpl>(){

            @Override
            public MessageImpl call(MessageExchangeDAO messageExchangeDAO) {
                MessageDAO messageDAO = messageExchangeDAO.getResponse();
                if (messageDAO == null) {
                    return null;
                }
                return new MemBackedMessageImpl(messageDAO.getHeader(), messageDAO.getData(), messageDAO.getType(), true);
            }
        });
        return this._response;
    }

    void request() {
        this._status = MessageExchange.Status.REQ;
    }

    void ack(MessageExchange.AckType ackType) {
        this._status = MessageExchange.Status.ACK;
        this._ackType = ackType;
    }

    public Message createMessage(QName qName) {
        return new MemBackedMessageImpl(null, null, qName, false);
    }

    public void setEndpointReference(EndpointReference endpointReference) {
        this._epr = endpointReference;
        this._changes.add(Change.EPR);
    }

    public EndpointReference getEndpointReference() throws BpelEngineException {
        if (this._epr != null) {
            return this._epr;
        }
        this._epr = this.doInTX(new InDbAction<EndpointReference>(){

            @Override
            public EndpointReference call(MessageExchangeDAO messageExchangeDAO) {
                Element element = messageExchangeDAO.getEPR();
                MessageExchangeImpl.this._epr = element == null ? null : MessageExchangeImpl.this._contexts.eprContext.resolveEndpointReference(messageExchangeDAO.getEPR());
                return MessageExchangeImpl.this._epr;
            }
        });
        return this._epr;
    }

    public String getProperty(final String string) {
        if (!this._loadedProperties.contains(string)) {
            this._properties.put(string, this.doInTX(new InDbAction<String>(){

                @Override
                public String call(MessageExchangeDAO messageExchangeDAO) {
                    return messageExchangeDAO.getProperty(string);
                }
            }));
            this._loadedProperties.add(string);
        }
        return this._properties.get(string);
    }

    public void setProperty(String string, String string2) {
        this._properties.put(string, string2);
        this._loadedProperties.add(string);
        this._modifiedProperties.add(string);
    }

    public Set<String> getPropertyNames() {
        if (this._propNames != null) {
            return this._propNames;
        }
        this._propNames = this.doInTX(new InDbAction<Set<String>>(){

            @Override
            public Set<String> call(MessageExchangeDAO messageExchangeDAO) {
                return messageExchangeDAO.getPropertyNames();
            }
        });
        return this._propNames;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long l) {
        this._timeout = l;
    }

    public void release() {
        __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
        this._changes.add(Change.RELEASE);
        this._process.releaseMessageExchange(this.getMessageExchangeId());
    }

    public String toString() {
        return "MEX[" + this._mexId + "]";
    }

    protected void assertTransaction() {
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("Operation must be performed in a transaction!");
        }
    }

    protected <T> T doInTX(final InDbAction<T> inDbAction) {
        if (this.isTransactional()) {
            this.assertTransaction();
            return inDbAction.call(this.getDAO());
        }
        try {
            return this._process.enqueueTransaction(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    MessageExchangeImpl.this.assertTransaction();
                    return inDbAction.call(MessageExchangeImpl.this.getDAO());
                }
            }).get();
        }
        catch (Exception exception) {
            __log.error((Object)"Internal error executing transaction.", (Throwable)exception);
            throw new BpelEngineException("Internal Error", (Throwable)exception);
        }
    }

    protected MessageExchangeDAO getDAO() {
        this.assertTransaction();
        return this._process.loadMexDao(this._mexId);
    }

    void sync() {
        ++this._syncdummy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InDbAction<T> {
        public T call(MessageExchangeDAO var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Change {
        EPR,
        ACK,
        RELEASE,
        REQUEST;

    }
}

