/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessStore;

public class ProcessAndInstanceManagementMBean
implements DynamicMBean {
    private MBeanInfo _mbeanInfo;
    private ProcessAndInstanceManagementImpl _pm;
    private static final List<String> __excludes = new ArrayList<String>();
    private static final Hashtable<String, Class<?>> primitives;

    public ProcessAndInstanceManagementMBean(BpelServer bpelServer, ProcessStore processStore) {
        this(new ProcessAndInstanceManagementImpl(bpelServer, processStore));
    }

    public ProcessAndInstanceManagementMBean(ProcessAndInstanceManagementImpl processAndInstanceManagementImpl) {
        this._pm = processAndInstanceManagementImpl;
        ArrayList<MBeanOperationInfo> arrayList = new ArrayList<MBeanOperationInfo>();
        for (Method mBeanNotificationInfoArray2 : processAndInstanceManagementImpl.getClass().getMethods()) {
            if (__excludes.contains(mBeanNotificationInfoArray2.getName())) continue;
            arrayList.add(new MBeanOperationInfo(mBeanNotificationInfoArray2.getName(), mBeanNotificationInfoArray2));
        }
        Object[] objectArray = new MBeanAttributeInfo[]{};
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[]{};
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[arrayList.size()];
        mBeanOperationInfoArray = arrayList.toArray(mBeanOperationInfoArray);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{};
        this._mbeanInfo = new MBeanInfo(this.getClass().getName(), "Process and Instance Management", (MBeanAttributeInfo[])objectArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public AttributeList getAttributes(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public MBeanInfo getMBeanInfo() {
        return this._mbeanInfo;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        try {
            Method method = this._pm.getClass().getMethod(string, this.findTypes(this._pm.getClass().getClassLoader(), stringArray));
            if (method == null) {
                throw new ReflectionException(new NoSuchMethodException(string));
            }
            return method.invoke((Object)this._pm, objectArray);
        }
        catch (Exception exception) {
            throw new ReflectionException(exception);
        }
    }

    private Class[] findTypes(ClassLoader classLoader, String[] stringArray) throws ReflectionException {
        if (stringArray == null) {
            return null;
        }
        Class[] classArray = new Class[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = primitives.get(stringArray[i]);
                if (classArray[i] != null) continue;
                classArray[i] = Class.forName(stringArray[i], false, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException);
        }
        return classArray;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        throw new UnsupportedOperationException();
    }

    static {
        __excludes.add("hashCode");
        __excludes.add("equals");
        __excludes.add("getClass");
        __excludes.add("wait");
        __excludes.add("notify");
        __excludes.add("notifyAll");
        __excludes.add("toString");
        primitives = new Hashtable();
        primitives.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitives.put(Character.TYPE.toString(), Character.TYPE);
        primitives.put(Byte.TYPE.toString(), Byte.TYPE);
        primitives.put(Short.TYPE.toString(), Short.TYPE);
        primitives.put(Integer.TYPE.toString(), Integer.TYPE);
        primitives.put(Long.TYPE.toString(), Long.TYPE);
        primitives.put(Float.TYPE.toString(), Float.TYPE);
        primitives.put(Double.TYPE.toString(), Double.TYPE);
    }
}

