/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MemBackedMessageImpl;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.ReliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreliableMyRoleMessageExchangeImpl
extends MyRoleMessageExchangeImpl {
    private static final Log __log = LogFactory.getLog(ReliableMyRoleMessageExchangeImpl.class);
    boolean _done = false;
    ResponseFuture _future;

    public UnreliableMyRoleMessageExchangeImpl(ODEProcess oDEProcess, String string, PartnerLinkModel partnerLinkModel, Operation operation, QName qName) {
        super(oDEProcess, string, partnerLinkModel, operation, qName);
    }

    @Override
    public Future<MessageExchange.Status> invokeAsync() {
        if (this._future != null) {
            return this._future;
        }
        if (this._request == null) {
            throw new IllegalStateException("Must call setRequest(...)!");
        }
        this._future = new ResponseFuture();
        this._process.enqueueTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MessageExchangeDAO messageExchangeDAO = UnreliableMyRoleMessageExchangeImpl.this.doInvoke();
                if (messageExchangeDAO.getStatus() == MessageExchange.Status.ACK) {
                    UnreliableMyRoleMessageExchangeImpl.this.onAsyncAck(messageExchangeDAO);
                }
                return null;
            }
        });
        return this._future;
    }

    @Override
    public InvocationStyle getInvocationStyle() {
        return InvocationStyle.UNRELIABLE;
    }

    @Override
    public MessageExchange.Status invokeBlocking() throws BpelEngineException, TimeoutException {
        if (this._done) {
            return this.getStatus();
        }
        Future<MessageExchange.Status> future = this._future != null ? this._future : this.invokeAsync();
        try {
            future.get(Math.max(this._timeout, 1L), TimeUnit.MILLISECONDS);
            this._done = true;
            return this.getStatus();
        }
        catch (InterruptedException interruptedException) {
            throw new BpelEngineException((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new BpelEngineException(executionException.getCause());
        }
    }

    @Override
    protected void onAsyncAck(MessageExchangeDAO messageExchangeDAO) {
        MemBackedMessageImpl memBackedMessageImpl;
        final QName qName = messageExchangeDAO.getFault();
        final MessageExchange.FailureType failureType = messageExchangeDAO.getFailureType();
        final MessageExchange.AckType ackType = messageExchangeDAO.getAckType();
        final String string = messageExchangeDAO.getFaultExplanation();
        switch (messageExchangeDAO.getAckType()) {
            case RESPONSE: 
            case FAULT: {
                memBackedMessageImpl = new MemBackedMessageImpl(messageExchangeDAO.getResponse().getHeader(), messageExchangeDAO.getResponse().getData(), messageExchangeDAO.getResponse().getType(), false);
                break;
            }
            default: {
                memBackedMessageImpl = null;
            }
        }
        UnreliableMyRoleMessageExchangeImpl unreliableMyRoleMessageExchangeImpl = this;
        ResponseFuture responseFuture = this._future;
        this._process.scheduleRunnable(new Runnable(){

            public void run() {
                UnreliableMyRoleMessageExchangeImpl.this._response = memBackedMessageImpl;
                UnreliableMyRoleMessageExchangeImpl.this._fault = qName;
                UnreliableMyRoleMessageExchangeImpl.this._failureType = failureType;
                UnreliableMyRoleMessageExchangeImpl.this._explanation = string;
                UnreliableMyRoleMessageExchangeImpl.this.ack(ackType);
                UnreliableMyRoleMessageExchangeImpl.this._future.done(MessageExchange.Status.ACK);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResponseFuture
    implements Future<MessageExchange.Status> {
        private MessageExchange.Status _status;

        private ResponseFuture() {
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public MessageExchange.Status get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw new RuntimeException(timeoutException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MessageExchange.Status get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            ResponseFuture responseFuture = this;
            synchronized (responseFuture) {
                if (this._status != null) {
                    return this._status;
                }
                this.wait(TimeUnit.MILLISECONDS.convert(l, timeUnit));
                if (this._status == null) {
                    throw new TimeoutException();
                }
                return this._status;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this._status != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(MessageExchange.Status status) {
            ResponseFuture responseFuture = this;
            synchronized (responseFuture) {
                this._status = status;
                this.notifyAll();
            }
        }
    }
}

