/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.BinaryStorageService;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Attachment;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InMemoryAttachment;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.StoredAttachment;
import org.eclipse.smila.datamodel.filter.RecordFilterHelper;
import org.eclipse.smila.datamodel.filter.RecordFilterNotFoundException;
import org.eclipse.smila.recordstorage.RecordStorage;
import org.eclipse.smila.recordstorage.RecordStorageException;
import org.eclipse.smila.utils.digest.DigestHelper;

public class BlackboardImpl
implements Blackboard {
    private final Log _log = LogFactory.getLog(this.getClass());
    private RecordStorage _recordStorage;
    private BinaryStorageService _binaryStorage;
    private final Map<String, Record> _recordMap = new HashMap<String, Record>();
    private final Collection<String> _recordsToDelete = new HashSet<String>();
    private final Map<String, Serializable> _globalNotes = new HashMap<String, Serializable>();
    private final Map<String, Map<String, Serializable>> _recordNotesMap = new HashMap<String, Map<String, Serializable>>();
    private final RecordFilterHelper _filterHelper;
    private final DataFactory _dataFactory = DataFactory.DEFAULT;

    public BlackboardImpl(RecordFilterHelper filterHelper) {
        this._filterHelper = filterHelper;
    }

    @Override
    public DataFactory getDataFactory() {
        return this._dataFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record getRecord(String id, Blackboard.Get mode) throws BlackboardAccessException {
        this.assertNotNull(id);
        Record record = null;
        if (mode == Blackboard.Get.NEW) {
            Map<String, Record> map = this._recordMap;
            synchronized (map) {
                this.evictRecord(id);
                record = this.getDataFactory().createRecord(id);
                this.putRecord(id, record);
            }
        }
        Map<String, Record> map = this._recordMap;
        synchronized (map) {
            record = this._recordMap.get(id);
            if (record == null) {
                if (!this._recordsToDelete.contains(id)) {
                    record = this.loadRecord(id);
                }
                if (record == null && mode == Blackboard.Get.AUTO_CREATE) {
                    record = this._dataFactory.createRecord(id);
                }
                this.putRecord(id, record);
            }
        }
        return record;
    }

    @Override
    public Record getRecord(String id) throws BlackboardAccessException {
        return this.getRecord(id, Blackboard.Get.EXISTING);
    }

    @Override
    public AnyMap getMetadata(String id) throws BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        if (record == null) {
            return null;
        }
        return record.getMetadata();
    }

    @Override
    public Record getRecord(String id, String filterName) throws RecordFilterNotFoundException, BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        return this.filterRecord(record, filterName);
    }

    @Override
    public Record filterRecord(Record record, String filterName) throws RecordFilterNotFoundException {
        if (record == null) {
            return null;
        }
        Record filteredRecord = this._filterHelper.filter(record, filterName);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("record to filter: " + record));
            this._log.debug((Object)("filtered record: " + filteredRecord));
        }
        return filteredRecord;
    }

    @Override
    public Record getRecordCopy(String id, boolean withAttachments) throws BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        Record copy = record.getFactory().createRecord(record, withAttachments);
        if (withAttachments && this._binaryStorage != null) {
            Iterator attachmentNames = copy.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = (String)attachmentNames.next();
                Attachment attachment = this.getAttachment(id, attachmentName);
                copy.setAttachment(attachment);
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecord(Record record) throws BlackboardAccessException {
        String id = this.assertIdNotNull(record);
        Map<String, Record> map = this._recordMap;
        synchronized (map) {
            this.putRecord(id, record);
        }
        if (this._binaryStorage != null && record.hasAttachments()) {
            Iterator attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = (String)attachmentNames.next();
                Attachment attachment = record.getAttachment(attachmentName);
                this.setAttachment(id, attachment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeRecord(Record record) throws BlackboardAccessException {
        String id = this.assertIdNotNull(record);
        Record oldRecord = this.getRecord(id);
        if (oldRecord == null) {
            this.setRecord(record);
        } else {
            Record record2 = oldRecord;
            synchronized (record2) {
                AnyMap metadata = record.getMetadata();
                this.copyAttributes(metadata, oldRecord.getMetadata());
                Iterator attachmentNames = record.getAttachmentNames();
                while (attachmentNames.hasNext()) {
                    String attachmentName = (String)attachmentNames.next();
                    Attachment attachment = record.getAttachment(attachmentName);
                    this.setAttachment(id, attachment);
                }
            }
        }
    }

    @Override
    public void removeRecord(String id) {
        this.assertNotNull(id);
        this._recordsToDelete.add(id);
    }

    @Override
    public void removeAll() {
        this._recordsToDelete.addAll(this.getRecordIds());
    }

    @Override
    public boolean hasAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        if (record == null) {
            return false;
        }
        return record.hasAttachment(name);
    }

    @Override
    public Attachment getAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        if (record != null && record.hasAttachment(name)) {
            if (this._binaryStorage != null) {
                try {
                    return new InMemoryAttachment(name, this._binaryStorage.fetchAsByte(this.getAttachmentId(id, name)));
                }
                catch (BinaryStorageException ex) {
                    throw new BlackboardAccessException("Could not get the attachment from binary storage for record " + id, ex);
                }
            }
            return record.getAttachment(name);
        }
        return null;
    }

    @Override
    public byte[] getAttachmentAsBytes(String id, String name) throws BlackboardAccessException {
        Attachment attachment = this.getAttachment(id, name);
        if (attachment == null) {
            return null;
        }
        return attachment.getAsBytes();
    }

    @Override
    public InputStream getAttachmentAsStream(String id, String name) throws BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        if (record != null && record.hasAttachment(name)) {
            if (this._binaryStorage == null) {
                return record.getAttachment(name).getAsStream();
            }
            try {
                return this._binaryStorage.fetchAsStream(this.getAttachmentId(id, name));
            }
            catch (BinaryStorageException bsex) {
                throw new BlackboardAccessException("Could not get the attachment stream from binary storage for record having id :" + id, bsex);
            }
        }
        return null;
    }

    @Override
    public void setAttachment(String id, Attachment attachment) throws BlackboardAccessException {
        Record record = this.assertRecordExists(id);
        if (this._binaryStorage == null || attachment instanceof StoredAttachment) {
            record.setAttachment(attachment);
        } else {
            String name = attachment.getName();
            this.storeAttachment(id, name, attachment.getAsStream());
            record.setAttachment((Attachment)new StoredAttachment(name, attachment.size()));
        }
    }

    @Override
    public void setAttachment(String id, String name, byte[] attachment) throws BlackboardAccessException {
        this.setAttachment(id, (Attachment)new InMemoryAttachment(name, attachment));
    }

    @Override
    public void setAttachmentFromStream(String id, String name, InputStream attachmentStream) throws BlackboardAccessException {
        Record record = this.assertRecordExists(id);
        if (this._binaryStorage == null) {
            try {
                record.setAttachment((Attachment)new InMemoryAttachment(name, IOUtils.toByteArray((InputStream)attachmentStream)));
            }
            catch (IOException ex) {
                throw new BlackboardAccessException("Error loading attachment stream in memory.", ex);
            }
        } else {
            long size = this.storeAttachment(id, name, attachmentStream);
            record.setAttachment((Attachment)new StoredAttachment(name, size));
        }
    }

    @Override
    public void setAttachmentFromFile(String id, String name, File attachmentFile) throws BlackboardAccessException {
        FileInputStream fileStream = null;
        try {
            try {
                fileStream = new FileInputStream(attachmentFile);
                this.setAttachmentFromStream(id, name, fileStream);
            }
            catch (IOException ex) {
                throw new BlackboardAccessException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileStream);
    }

    @Override
    public void removeAttachment(String id, String name) throws BlackboardAccessException {
        Record record = this.assertRecordExists(id);
        record.removeAttachment(name);
        if (this._binaryStorage != null) {
            try {
                String attachmentId = this.getAttachmentId(id, name);
                this._binaryStorage.remove(attachmentId);
            }
            catch (BinaryStorageException ex) {
                throw new BlackboardAccessException("Failed to remove attachment " + name + " from binary storage for record " + id, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGlobalNote(String name) {
        Map<String, Serializable> map = this._globalNotes;
        synchronized (map) {
            return this._globalNotes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getGlobalNote(String name) {
        Map<String, Serializable> map = this._globalNotes;
        synchronized (map) {
            return this._globalNotes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalNote(String name, Serializable object) {
        Map<String, Serializable> map = this._globalNotes;
        synchronized (map) {
            this._globalNotes.put(name, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRecordNote(String id, String name) {
        this.assertNotNull(id);
        Map<String, Map<String, Serializable>> map = this._recordNotesMap;
        synchronized (map) {
            Map<String, Serializable> recordNotes;
            block4: {
                recordNotes = this._recordNotesMap.get(id);
                if (recordNotes != null) break block4;
                return false;
            }
            return recordNotes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getRecordNote(String id, String name) {
        this.assertNotNull(id);
        Map<String, Map<String, Serializable>> map = this._recordNotesMap;
        synchronized (map) {
            Map<String, Serializable> recordNotes;
            block4: {
                recordNotes = this._recordNotesMap.get(id);
                if (recordNotes != null) break block4;
                return null;
            }
            return recordNotes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecordNote(String id, String name, Serializable object) {
        this.assertNotNull(id);
        Map<String, Map<String, Serializable>> map = this._recordNotesMap;
        synchronized (map) {
            Map<String, Serializable> recordNotes = this._recordNotesMap.get(id);
            if (recordNotes == null) {
                recordNotes = new HashMap<String, Serializable>();
                recordNotes.put(name, object);
                this._recordNotesMap.put(id, recordNotes);
            } else {
                recordNotes.put(name, object);
                this._recordNotesMap.put(id, recordNotes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitRecord(String id) throws BlackboardAccessException {
        this.assertNotNull(id);
        boolean isRemoved = false;
        Collection<String> collection = this._recordsToDelete;
        synchronized (collection) {
            isRemoved = this._recordsToDelete.contains(id);
        }
        if (isRemoved) {
            this.deleteRecord(id);
            this.evictRecord(id);
        } else {
            this.storeRecord(id);
        }
    }

    @Override
    public void unloadRecord(String id) {
        Record record = this.evictRecord(id);
        try {
            if (this._recordStorage != null && !this._recordStorage.existsRecord(id)) {
                this.removeAttachmentsFromBinaryStorage(record);
            }
        }
        catch (RecordStorageException ex) {
            this._log.warn((Object)("Error checking if record " + id + " exists in record storage"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws BlackboardAccessException {
        int commitFailures = 0;
        int numberOfRecords = 0;
        Map<String, Record> map = this._recordMap;
        synchronized (map) {
            numberOfRecords = this._recordMap.size();
            for (String id : this.getRecordIds()) {
                try {
                    this.commitRecord(id);
                }
                catch (Exception ex) {
                    ++commitFailures;
                    this._log.error((Object)("failed to commit: " + id), (Throwable)ex);
                }
            }
        }
        if (commitFailures > 0) {
            throw new BlackboardAccessException("Failed to commit " + commitFailures + " of " + numberOfRecords + " records on blackboard, see log for IDs.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        Object object = this._recordMap;
        synchronized (object) {
            for (String id : this.getRecordIds()) {
                try {
                    this.unloadRecord(id);
                }
                catch (Exception ex) {
                    this._log.warn((Object)("failed to invalidate: " + id), (Throwable)ex);
                }
            }
            this._recordMap.clear();
        }
        object = this._globalNotes;
        synchronized (object) {
            this._globalNotes.clear();
        }
        object = this._recordNotesMap;
        synchronized (object) {
            this._recordNotesMap.clear();
        }
        object = this._recordsToDelete;
        synchronized (object) {
            this._recordsToDelete.clear();
        }
    }

    protected void setRecordStorage(RecordStorage recordStorage) {
        this._recordStorage = recordStorage;
    }

    protected void setBinaryStorage(BinaryStorageService binaryStorage) {
        this._binaryStorage = binaryStorage;
    }

    private String assertIdNotNull(Record record) {
        if (record == null) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        String id = record.getId();
        this.assertNotNull(id);
        return id;
    }

    private void assertNotNull(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Record Id cannot be null");
        }
    }

    private Collection<String> getRecordIds() {
        return new ArrayList<String>(this._recordMap.keySet());
    }

    private Record assertRecordExists(String id) throws BlackboardAccessException {
        Record record = this.getRecord(id, Blackboard.Get.EXISTING);
        if (record == null) {
            throw new BlackboardAccessException("Record " + id + " does not exist.");
        }
        return record;
    }

    private Record loadRecord(String id) throws BlackboardAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Record ID cannot be null");
        }
        Record record = null;
        if (this._recordStorage != null) {
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Loading record id: " + id + " from record storage."));
                }
                record = this._recordStorage.loadRecord(id);
            }
            catch (RecordStorageException ex) {
                throw new BlackboardAccessException("Error loading record with id = " + id, ex);
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeRecord(String id) throws BlackboardAccessException {
        try {
            Record record = null;
            Map<String, Record> map = this._recordMap;
            synchronized (map) {
                record = this._recordMap.get(id);
                if (record == null) {
                    throw new BlackboardAccessException("Record " + id + " not loaded on blackboard, cannot commit it.");
                }
            }
            if (this._recordStorage != null) {
                this._recordStorage.storeRecord(record);
            }
        }
        catch (RecordStorageException ex) {
            throw new BlackboardAccessException("Error committing record " + id + " to record storage", ex);
        }
    }

    private void deleteRecord(String id) {
        try {
            Record record = this.getRecord(id, Blackboard.Get.EXISTING);
            if (record != null) {
                this.removeAttachmentsFromBinaryStorage(record);
            }
        }
        catch (BlackboardAccessException ex) {
            this._log.warn((Object)("Failed to read record " + id + " for removal of attachments."), (Throwable)ex);
        }
        if (this._recordStorage != null) {
            try {
                this._recordStorage.removeRecord(id);
            }
            catch (RecordStorageException ex) {
                this._log.warn((Object)("Failed to record " + id + " from record storage."), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record evictRecord(String id) {
        this.assertNotNull(id);
        Record record = null;
        Map<String, Object> map = this._recordMap;
        synchronized (map) {
            record = this._recordMap.remove(id);
        }
        map = this._recordNotesMap;
        synchronized (map) {
            this._recordNotesMap.remove(id);
        }
        return record;
    }

    private void putRecord(String id, Record record) {
        this._recordMap.put(id, record);
        this._recordsToDelete.remove(id);
    }

    private void copyAttributes(AnyMap source, AnyMap destination) {
        for (Map.Entry entry : source.entrySet()) {
            if ("_recordid".equals(entry.getKey())) continue;
            destination.put((String)entry.getKey(), this._dataFactory.cloneAny((Any)entry.getValue()));
        }
    }

    private String getAttachmentId(String id, String name) {
        return DigestHelper.calculateDigest((String)(String.valueOf(id) + "_ATTACHMENT_" + name));
    }

    private long storeAttachment(String id, String name, InputStream attachment) throws BlackboardAccessException {
        String attachmentId = this.getAttachmentId(id, name);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Saving attachment " + attachmentId + " to binary storage"));
        }
        try {
            this._binaryStorage.store(attachmentId, attachment);
            return this._binaryStorage.fetchSize(attachmentId);
        }
        catch (BinaryStorageException bsex) {
            throw new BlackboardAccessException("Failed to save attachment in binary storage for record having id :" + id, bsex);
        }
    }

    private void removeAttachmentsFromBinaryStorage(Record record) {
        if (this._binaryStorage != null && record != null && record.hasAttachments()) {
            Iterator attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = (String)attachmentNames.next();
                try {
                    this._binaryStorage.remove(this.getAttachmentId(record.getId(), attachmentName));
                }
                catch (BinaryStorageException storageException) {
                    this._log.error((Object)("Could not delete the attachment-file from binary storage for record having id :" + record.getId() + " - " + storageException.getMessage()));
                }
            }
        }
    }
}

