/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.output;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.output.Output;
import org.eclipse.smila.taskworker.util.Counters;

public class AppendableOutput
extends Output {
    private final IpcAnyWriter _ipcAnyWriter = new IpcAnyWriter();
    private final IpcRecordWriter _ipcRecordWriter = new IpcRecordWriter();
    private long _bytesWritten;
    private long _recordCount;

    public AppendableOutput(BulkInfo dataObject, ObjectStoreService objectStore) {
        super(dataObject, objectStore);
    }

    public void append(byte[] data) throws ObjectStoreException {
        this.append(data, null);
    }

    public void append(byte[] data, Integer numberOfRecords) throws ObjectStoreException {
        long start = this.startTime();
        this._objectStore.appendToObject(this.getStoreName(), this.getObjectName(), data);
        if (numberOfRecords != null) {
            this._recordCount += (long)numberOfRecords.intValue();
        }
        this._bytesWritten += (long)data.length;
        this.timePerform(start);
    }

    public void appendRecord(Record record) throws ObjectStoreException, IOException {
        this.append(this._ipcRecordWriter.writeBinaryObject(record), 1);
    }

    public void appendAny(Any object) throws ObjectStoreException, IOException {
        this.append(this._ipcAnyWriter.writeBinaryObject(object), 1);
    }

    @Override
    public void commit() throws ObjectStoreException {
        this._objectStore.finishObject(this.getStoreName(), this.getObjectName());
    }

    @Override
    public void abort() throws ObjectStoreException {
        this._objectStore.finishObject(this.getStoreName(), this.getObjectName());
    }

    public long getBytesWritten() {
        return this._bytesWritten;
    }

    public long getRecordCount() {
        return this._recordCount;
    }

    @Override
    public Map<String, Number> getCounter() {
        Map<String, Number> counter = super.getCounter();
        Counters.add(counter, "size", this._bytesWritten);
        if (this._recordCount > 0L) {
            Counters.add(counter, "recordCount", this._recordCount);
        }
        return counter;
    }
}

