/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.helpers;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;

public final class OutWriter {
    private OutWriter() {
    }

    public static void writeOut(String str) {
        System.out.println(str);
    }

    public static void write(String echo, Log log) {
        log.info((Object)echo);
    }

    public static void write(String echo, Object object, Log log) {
        if (object == null) {
            OutWriter.writeLine(String.format("%s... %s.", echo, "NULL."), log);
            return;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            if (objectArray.length == 0) {
                OutWriter.writeLine(String.format("%s... NO.", echo), log);
            } else {
                OutWriter.writeLine(echo, log);
                Object[] objectArray2 = objectArray;
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object o = objectArray2[n3];
                    OutWriter.writeItemList(++n, o, log);
                    ++n3;
                }
            }
        } else if (Collection.class.isAssignableFrom(object.getClass())) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                OutWriter.writeLine(String.format("%s... NO.", echo), log);
            } else {
                Iterator it = collection.iterator();
                int n = 0;
                OutWriter.writeLine(echo, log);
                while (it.hasNext()) {
                    OutWriter.writeItemList(++n, it.next(), log);
                }
            }
        } else {
            OutWriter.writeLine(String.format("%s... %s.", echo, object), log);
        }
    }

    private static void writeItemList(int n, Object o, Log log) {
        log.info((Object)String.format("%d. %s", n, o));
    }

    private static void writeLine(Object o, Log log) {
        log.info(o);
    }
}

