/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.solr.search.function.ValueSourceScorer;

public abstract class DocValues {
    public byte byteVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public short shortVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public float floatVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public int intVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public long longVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public double doubleVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public String strVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public abstract String toString(int var1);

    public void byteVal(int doc, byte[] vals) {
        throw new UnsupportedOperationException();
    }

    public void shortVal(int doc, short[] vals) {
        throw new UnsupportedOperationException();
    }

    public void floatVal(int doc, float[] vals) {
        throw new UnsupportedOperationException();
    }

    public void intVal(int doc, int[] vals) {
        throw new UnsupportedOperationException();
    }

    public void longVal(int doc, long[] vals) {
        throw new UnsupportedOperationException();
    }

    public void doubleVal(int doc, double[] vals) {
        throw new UnsupportedOperationException();
    }

    public void strVal(int doc, String[] vals) {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(int doc) {
        return new Explanation(this.floatVal(doc), this.toString(doc));
    }

    public ValueSourceScorer getScorer(IndexReader reader) {
        return new ValueSourceScorer(reader, this);
    }

    public ValueSourceScorer getRangeScorer(IndexReader reader, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        float lower = lowerVal == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerVal);
        float upper = upperVal == null ? Float.POSITIVE_INFINITY : Float.parseFloat(upperVal);
        final float l = lower;
        final float u = upper;
        if (includeLower && includeUpper) {
            return new ValueSourceScorer(reader, this){

                public boolean matchesValue(int doc) {
                    float docVal = DocValues.this.floatVal(doc);
                    return docVal >= l && docVal <= u;
                }
            };
        }
        if (includeLower && !includeUpper) {
            return new ValueSourceScorer(reader, this){

                public boolean matchesValue(int doc) {
                    float docVal = DocValues.this.floatVal(doc);
                    return docVal >= l && docVal < u;
                }
            };
        }
        if (!includeLower && includeUpper) {
            return new ValueSourceScorer(reader, this){

                public boolean matchesValue(int doc) {
                    float docVal = DocValues.this.floatVal(doc);
                    return docVal > l && docVal <= u;
                }
            };
        }
        return new ValueSourceScorer(reader, this){

            public boolean matchesValue(int doc) {
                float docVal = DocValues.this.floatVal(doc);
                return docVal > l && docVal < u;
            }
        };
    }
}

