/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.bon;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.bon.BinaryToken;
import org.eclipse.smila.ipc.bon.ValueTrafo;

public class BinaryStreamReader
implements IpcStreamReader {
    private BinaryToken _currentToken;
    private byte[] _currentValue;
    private final InputStream _stream;

    BinaryStreamReader(InputStream stream) {
        this._stream = stream;
    }

    @Override
    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }

    @Override
    public void closeWithoutStream() throws IOException {
    }

    @Override
    public boolean currentBoolValue() {
        if (this._currentToken == BinaryToken.SCALAR_BOOL_TRUE) {
            return true;
        }
        if (this._currentToken == BinaryToken.SCALAR_BOOL_FALSE) {
            return false;
        }
        throw new IllegalStateException("Current token is not a boolean value: " + (Object)((Object)this._currentToken));
    }

    @Override
    public double currentDoubleValue() {
        if (this._currentToken.asIpcToken() != IpcToken.SCALAR_DOUBLE) {
            throw new IllegalStateException("Current token is not a double value: " + (Object)((Object)this._currentToken));
        }
        return ValueTrafo.byte2double(this._currentValue);
    }

    @Override
    public long currentLongValue() {
        if (this._currentToken.asIpcToken() != IpcToken.SCALAR_INT) {
            throw new IllegalStateException("Current token is not an int value: " + (Object)((Object)this._currentToken));
        }
        long v = ValueTrafo.byte2long(this._currentValue);
        return this._currentToken.hasNegativeValue() ? -v : v;
    }

    @Override
    public String currentStringValue() {
        if (this._currentToken.asIpcToken() == IpcToken.SCALAR_STRING || this._currentToken.asIpcToken() == IpcToken.BINARY) {
            return ValueTrafo.byte2string(this._currentValue);
        }
        if (this._currentToken.asIpcToken() == IpcToken.SCALAR_DOUBLE) {
            return String.valueOf(ValueTrafo.byte2double(this._currentValue));
        }
        if (this._currentToken.asIpcToken() == IpcToken.SCALAR_INT) {
            return String.valueOf(ValueTrafo.byte2long(this._currentValue));
        }
        if (this._currentToken == BinaryToken.SCALAR_BOOL_FALSE) {
            return String.valueOf(Boolean.FALSE);
        }
        if (this._currentToken == BinaryToken.SCALAR_BOOL_TRUE) {
            return String.valueOf(Boolean.TRUE);
        }
        return null;
    }

    @Override
    public byte[] currentBinaryValue() {
        return this._currentValue;
    }

    @Override
    public boolean nextBoolValue() throws IOException {
        this.readTokenFromStream();
        return this.currentBoolValue();
    }

    @Override
    public double nextDoubleValue() throws IOException {
        this.readTokenFromStream();
        this.readValueFromStream();
        return this.currentDoubleValue();
    }

    @Override
    public long nextLongValue() throws IOException {
        this.readTokenFromStream();
        this.readValueFromStream();
        return this.currentLongValue();
    }

    @Override
    public String nextStringValue() throws IOException {
        this.readTokenFromStream();
        this.readValueFromStream();
        return this.currentStringValue();
    }

    @Override
    public byte[] nextBinaryValue() throws IOException {
        this.readTokenFromStream();
        this.readValueFromStream();
        return this.currentBinaryValue();
    }

    @Override
    public IpcToken nextToken() throws IOException {
        this.readTokenFromStream();
        if (this._currentToken == null) {
            return null;
        }
        if (this._currentToken.hasValue()) {
            this.readValueFromStream();
        } else {
            this._currentValue = null;
        }
        return this._currentToken.asIpcToken();
    }

    private void readTokenFromStream() throws IOException {
        this._currentToken = this.readAndCheckToken();
        if (this._currentToken == BinaryToken.CUSTOM) {
            this._currentToken = this.readAndCheckToken();
            if (this._currentToken.asIpcToken() != IpcToken.SCALAR_STRING) {
                throw new IllegalStateException("Invalid token after Custom token: " + (Object)((Object)this._currentToken));
            }
            this.readValueFromStream();
            this._currentToken = this.readAndCheckToken();
        }
    }

    private BinaryToken readAndCheckToken() throws IOException {
        int b = this._stream.read();
        if (b < 0) {
            return null;
        }
        BinaryToken token = BinaryToken.getToken(b);
        if (token == null) {
            throw new IllegalStateException("Invalid token byte " + b);
        }
        return token;
    }

    private void readValueFromStream() throws IOException {
        this.readValueFromStream(this._currentToken.valueLength());
        if (this._currentToken.asIpcToken() == IpcToken.SCALAR_STRING) {
            int stringLength = ValueTrafo.byte2int(this._currentValue);
            this.readValueFromStream(stringLength);
        }
        if (this._currentToken.asIpcToken() == IpcToken.BINARY) {
            int binaryLength = ValueTrafo.byte2int(this._currentValue);
            this.readValueFromStream(binaryLength);
        }
    }

    private void readValueFromStream(int length) throws IOException {
        this._currentValue = new byte[length];
        int readLength = 0;
        while (readLength < length) {
            int nextRead = this._stream.read(this._currentValue, readLength, length - readLength);
            if (nextRead < 0) {
                throw new IOException("got only " + readLength + " value bytes when " + length + " where required.");
            }
            readLength += nextRead;
        }
    }

    @Override
    public InputStream getStream() {
        return this._stream;
    }
}

