/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;

public class BinaryObjectStreamIterator
implements AutoCloseable {
    private final InputStream _binaryStream;
    private final IpcRecordReader _parser = new IpcRecordReader();
    private Record _nextObject;
    private boolean _finished;

    public BinaryObjectStreamIterator(InputStream binaryStream) {
        this._binaryStream = binaryStream;
    }

    public boolean hasNext() throws IOException {
        if (!this._finished) {
            try {
                if (this._nextObject == null) {
                    this._nextObject = this._parser.readBinaryStream(this._binaryStream);
                }
            }
            finally {
                if (this._nextObject == null) {
                    this.close();
                }
            }
        }
        return !this._finished;
    }

    public Record next() throws IOException {
        if (this._nextObject == null && !this.hasNext()) {
            throw new NoSuchElementException("No more objects available");
        }
        Record result = this._nextObject;
        this._nextObject = null;
        return result;
    }

    @Override
    public void close() {
        this._nextObject = null;
        this._finished = true;
        IOUtils.closeQuietly((InputStream)this._binaryStream);
    }
}

