/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.json.JsonFactory;

public class IpcAnyWriter {
    public static final String ENCODING = "UTF-8";
    private final IpcFactory _binaryFactory = new BinaryFactory();
    private final IpcFactory _jsonFactory;

    public IpcAnyWriter() {
        this(false);
    }

    public IpcAnyWriter(boolean printPretty) {
        this._jsonFactory = new JsonFactory(printPretty);
    }

    public byte[] writeBinaryObject(Any any) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeBinaryStream(any, outputStream);
        return outputStream.toByteArray();
    }

    public void writeBinaryStream(Any any, OutputStream stream) throws IOException {
        IpcStreamWriter writer = this._binaryFactory.newStreamWriter(stream);
        this.writeStream(any, writer);
    }

    public String writeJsonObject(Any any) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeJsonStream(any, outputStream);
        return new String(outputStream.toByteArray(), ENCODING);
    }

    public void writeJsonStream(Any any, OutputStream stream) throws IOException {
        IpcStreamWriter writer = this._jsonFactory.newStreamWriter(stream);
        this.writeStream(any, writer);
    }

    public void writeStream(Any any, IpcStreamWriter writer) throws IOException {
        try {
            writer.writeObjectStart();
            this.writeAny(writer, any);
            writer.writeObjectEnd();
        }
        finally {
            writer.closeWithoutStream();
        }
    }

    void writeAny(IpcStreamWriter writer, Any any) throws IOException {
        if (any != null) {
            if (any.isMap()) {
                this.writeMap(writer, (AnyMap)any);
            } else if (any.isSeq()) {
                this.writeSeq(writer, (AnySeq)any);
            } else if (any.isValue()) {
                this.writeValue(writer, (Value)any);
            }
        }
    }

    private void writeMap(IpcStreamWriter writer, AnyMap object) throws IOException {
        if (object != null) {
            writer.writeMappingStart();
            if (!object.isEmpty()) {
                for (Map.Entry childEntry : object.entrySet()) {
                    String childKey = (String)childEntry.getKey();
                    writer.writeMappingKey(childKey);
                    Any any = (Any)childEntry.getValue();
                    this.writeAny(writer, any);
                }
            }
            writer.writeMappingEnd();
        }
    }

    private void writeSeq(IpcStreamWriter writer, AnySeq seq) throws IOException {
        writer.writeSequenceStart();
        for (Any any : seq) {
            this.writeAny(writer, any);
        }
        writer.writeSequenceEnd();
    }

    private void writeValue(IpcStreamWriter writer, Value value) throws IOException {
        if (value != null) {
            if (value.isBoolean()) {
                writer.writeScalarBoolean(value.asBoolean().booleanValue());
            } else if (value.isLong()) {
                writer.writeScalarLong(value.asLong().longValue());
            } else if (value.isDouble()) {
                writer.writeScalarDouble(value.asDouble().doubleValue());
            } else {
                writer.writeScalarString(value.asString());
            }
        }
    }
}

