/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.impl.DefaultDataFactoryImpl;

public final class AnyUtil {
    public static final AnyMap EMPTY_MAP = DefaultDataFactoryImpl.IMMUTABLE_EMPTY_MAP;

    private AnyUtil() {
    }

    public static Object anyToNative(Any any) {
        if (any.isMap()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String key : ((AnyMap)any).keySet()) {
                map.put(key, AnyUtil.anyToNative((Any)((AnyMap)any).get(key)));
            }
            return map;
        }
        if (any.isSeq()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Any a : any) {
                list.add(AnyUtil.anyToNative(a));
            }
            return list;
        }
        if (any.isString()) {
            return ((Value)any).asString();
        }
        if (any.isLong()) {
            return ((Value)any).asLong();
        }
        if (any.isDouble()) {
            return ((Value)any).asDouble();
        }
        if (any.isBoolean()) {
            return ((Value)any).asBoolean();
        }
        if (any.isDate()) {
            return ((Value)any).asDate();
        }
        if (any.isDateTime()) {
            return ((Value)any).asDateTime();
        }
        return ((Value)any).getObject();
    }

    public static Any objectToAny(Object object) {
        Any value = null;
        if (object instanceof Any) {
            return (Any)object;
        }
        if (object instanceof Map) {
            value = AnyUtil.mapToAny((Map)object);
        } else if (object instanceof Collection) {
            value = AnyUtil.collectionToAny((Collection)object);
        } else if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            value = AnyUtil.collectionToAny(Arrays.asList(array));
        } else {
            value = AnyUtil.scalarObjectToAny(object);
        }
        return value;
    }

    private static AnySeq collectionToAny(Collection<Object> objects) {
        AnySeq anySeq = null;
        if (objects != null) {
            anySeq = DataFactory.DEFAULT.createAnySeq();
            for (Object obj : objects) {
                anySeq.add(AnyUtil.objectToAny(obj));
            }
        }
        return anySeq;
    }

    private static Any scalarObjectToAny(Object obj) {
        return DataFactory.DEFAULT.autoConvertValue(obj);
    }

    private static AnyMap mapToAny(Map<String, Object> map) {
        AnyMap anyMap = null;
        if (map != null) {
            anyMap = DataFactory.DEFAULT.createAnyMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                anyMap.put(entry.getKey(), AnyUtil.objectToAny(entry.getValue()));
            }
        }
        return anyMap;
    }

    public static Any saveGet(Any any, String[] path) {
        if (path.length == 0) {
            return DataFactory.DEFAULT.createAnyMap();
        }
        try {
            Any current = any;
            String[] stringArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                current = current.isMap() ? (Any)((AnyMap)current).get(key) : null;
                ++n2;
            }
            if (current == null) {
                return DataFactory.DEFAULT.createStringValue("undef");
            }
            return current;
        }
        catch (Exception exception) {
            return DataFactory.DEFAULT.createStringValue("undef");
        }
    }

    public static AnyMap exceptionToAny(Throwable e) {
        return AnyUtil.exceptionToAny(e, new HashSet<String>());
    }

    private static AnyMap exceptionToAny(Throwable e, Collection<String> visitedLines) {
        AnyMap any = DataFactory.DEFAULT.createAnyMap();
        any.put("type", e.getClass().getName());
        if (e.getMessage() != null) {
            any.put("message", e.getMessage());
        }
        AnySeq st = DataFactory.DEFAULT.createAnySeq();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stElement = stackTraceElementArray[n2];
            String line = stElement.toString();
            st.add(line);
            if (!visitedLines.add(line)) {
                st.add("...");
                break;
            }
            ++n2;
        }
        any.put("at", st);
        if (e.getCause() != null && e.getCause() != e) {
            any.put("causedBy", AnyUtil.exceptionToAny(e.getCause(), visitedLines));
        }
        return any;
    }

    public static Double asDouble(Any any) {
        return any == null ? null : any.asValue().asDouble();
    }

    public static Boolean asBoolean(Any any) {
        return any == null ? null : any.asValue().asBoolean();
    }

    public static Date asDateTime(Any any) {
        return any == null ? null : any.asValue().asDateTime();
    }

    public static Date asDate(Any any) {
        return any == null ? null : any.asValue().asDate();
    }

    public static Long asLong(Any any) {
        return any == null ? null : any.asValue().asLong();
    }

    public static String asString(Any any) {
        return any == null ? null : any.asValue().asString();
    }

    public static AnyMap asMap(Any any) {
        return any == null ? null : any.asMap();
    }

    public static AnySeq asSeq(Any any) {
        return any == null ? null : any.asSeq();
    }

    public static Properties anyToProperties(AnyMap anyMap) {
        Properties props = new Properties();
        Set entrySet = anyMap.entrySet();
        for (Map.Entry entry : entrySet) {
            props.put(entry.getKey(), ((Any)entry.getValue()).toString());
        }
        return props;
    }

    public static AnyMap propertiesToAny(Properties props) {
        AnyMap any = DataFactory.DEFAULT.createAnyMap();
        Set<String> propNames = props.stringPropertyNames();
        for (String prop : propNames) {
            any.put(prop, props.getProperty(prop));
        }
        return any;
    }

    public static AnyMap findMapInSeq(AnySeq seq, String keyName, String keyValue) {
        for (Any any : seq) {
            String stringValue = any.asMap().getStringValue(keyName);
            if (!keyValue.equals(stringValue)) continue;
            return any.asMap();
        }
        return null;
    }
}

