/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v2.ACTIVITY;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.InvalidContextException;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OPickReceive;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.Selector;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.PickResponseChannel;
import org.apache.ode.bpel.rtrep.v2.channels.PickResponseChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PICK
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(PICK.class);
    private OPickReceive _opick;
    private OPickReceive.OnAlarm _alarm = null;

    public PICK(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._opick = (OPickReceive)activityInfo.o;
    }

    public void run() {
        PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
        try {
            Date date;
            Selector[] selectorArray = new Selector[this._opick.onMessages.size()];
            int n = 0;
            for (OPickReceive.OnMessage onMessage : this._opick.onMessages) {
                date = null;
                PartnerLinkInstance partnerLinkInstance = this._scopeFrame.resolve(onMessage.partnerLink);
                if (onMessage.matchCorrelation == null && !this._opick.createInstanceFlag) {
                    String string = this.getBpelRuntime().fetchMySessionId(partnerLinkInstance);
                    date = new CorrelationKey(-1, new String[]{string});
                } else if (onMessage.matchCorrelation != null) {
                    if (!this.getBpelRuntime().isCorrelationInitialized(this._scopeFrame.resolve(onMessage.matchCorrelation))) {
                        if (!this._opick.createInstanceFlag) {
                            throw new FaultException(this._opick.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                        }
                    } else {
                        date = this.getBpelRuntime().readCorrelation(this._scopeFrame.resolve(onMessage.matchCorrelation));
                        assert (date != null);
                    }
                }
                selectorArray[n] = new Selector(n, partnerLinkInstance, onMessage.operation.getName(), onMessage.operation.getOutput() == null, onMessage.messageExchangeId, (CorrelationKey)date);
                ++n;
            }
            Date date2 = null;
            for (OPickReceive.OnAlarm onAlarm : this._opick.onAlarms) {
                Date date3 = date = onAlarm.forExpr != null ? PICK.offsetFromNow(this.getBpelRuntime().getExpLangRuntime().evaluateAsDuration(onAlarm.forExpr, this.getEvaluationContext())) : this.getBpelRuntime().getExpLangRuntime().evaluateAsDate(onAlarm.untilExpr, this.getEvaluationContext()).getTime();
                if (date2 != null && date2.compareTo(date) <= 0) continue;
                date2 = date;
                this._alarm = onAlarm;
            }
            this.getBpelRuntime().select(pickResponseChannel, date2, this._opick.createInstanceFlag, selectorArray);
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            FaultData faultData = this.createFault(faultException.getQName(), this._opick, faultException.getMessage());
            this.dpe(this._opick.outgoingLinks);
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
            return;
        }
        for (OPickReceive.OnAlarm onAlarm : this._opick.onAlarms) {
            if (onAlarm.equals(this._alarm)) continue;
            this.dpe(onAlarm.activity);
        }
        PICK.instance((JacobRunnable)new WAITING(this._scopeFrame, pickResponseChannel));
    }

    private static Date offsetFromNow(Duration duration) {
        Calendar calendar = Calendar.getInstance();
        duration.addTo(calendar);
        return calendar.getTime();
    }

    private void initVariable(String string, OPickReceive.OnMessage onMessage) {
        String string22;
        Element element;
        if (onMessage.variable == null) {
            return;
        }
        try {
            element = this.getBpelRuntime().getMyRequest(string);
        }
        catch (BpelEngineException bpelEngineException) {
            __log.error((Object)"The message exchange seems to be in an unconsistent state, you're probably missing a reply on a request/response interaction.");
            this._self.parent.failure(bpelEngineException.toString(), null);
            return;
        }
        Set set = onMessage.operation.getInput().getMessage().getParts().keySet();
        if (!(onMessage.variable.type instanceof OMessageVarType)) {
            String string3 = "Non-message variable for receive: should have been picked up by static analysis.";
            __log.fatal((Object)string3);
            throw new InvalidProcessException(string3);
        }
        OMessageVarType oMessageVarType = (OMessageVarType)onMessage.variable.type;
        for (String string22 : set) {
            Object object;
            Object object2;
            QName qName = new QName(null, string22);
            Element element2 = DOMUtils.findChildByName((Element)element, (QName)qName);
            OMessageVarType.Part part = oMessageVarType.parts.get(string22);
            if (part == null) {
                object2 = "Inconsistent WSDL, part " + string22 + " not found in message type " + oMessageVarType.messageType;
                __log.fatal(object2);
                throw new InvalidProcessException((String)object2);
            }
            if (element2 == null) {
                object2 = "Message missing part: " + string22;
                __log.fatal(object2);
                throw new InvalidContextException((String)object2);
            }
            if (!(part.type instanceof OElementVarType)) continue;
            object2 = (OElementVarType)part.type;
            Element element3 = DOMUtils.getFirstChildElement((Element)element2);
            if (element3 == null) {
                object = "Message (element) part " + string22 + " did not contain child element.";
                __log.fatal(object);
                throw new InvalidContextException((String)object);
            }
            if (((OElementVarType)object2).elementType.getLocalPart().equals("simpelWrapper") || ((QName)(object = new QName(element3.getNamespaceURI(), element3.getLocalName()))).equals(((OElementVarType)object2).elementType)) continue;
            String string4 = "Message (element) part " + string22 + " did not contain correct child element: expected " + ((OElementVarType)object2).elementType + " but got " + object;
            __log.fatal((Object)string4);
            throw new InvalidContextException(string4);
        }
        VariableInstance variableInstance = this._scopeFrame.resolve(onMessage.variable);
        try {
            this.initializeVariable(variableInstance, element);
        }
        catch (ExternalVariableModuleException externalVariableModuleException) {
            __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
            this._self.parent.failure(externalVariableModuleException.toString(), null);
            return;
        }
        string22 = new VariableModificationEvent(variableInstance.declaration.name);
        string22.setNewValue((Node)element);
        if (this._opick.debugInfo != null) {
            string22.setLineNo(this._opick.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)string22);
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(ScopeFrame scopeFrame, PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            WAITING.object((boolean)false, (Set)new PickResponseChannelListener(this._pickResponseChannel){
                private static final long serialVersionUID = -8237296827418738011L;

                public void onRequestRcvd(int n, String string) {
                    OPickReceive.OnMessage onMessage = ((PICK)PICK.this)._opick.onMessages.get(n);
                    for (OPickReceive.OnMessage object2 : ((PICK)PICK.this)._opick.onMessages) {
                        if (object2.equals(onMessage)) continue;
                        PICK.this.dpe(object2.activity);
                    }
                    if (PICK.this._alarm != null) {
                        PICK.this.dpe(((PICK)PICK.this)._alarm.activity);
                    }
                    if (((PICK)PICK.this)._opick.onMessages.size() > 1 && onMessage.operation.getOutput() == null) {
                        WAITING.this.getBpelRuntime().cancelOutstandingRequests(WAITING.this._pickResponseChannel.export());
                    }
                    PICK.this.initVariable(string, onMessage);
                    try {
                        for (OScope.CorrelationSet correlationSet : onMessage.initCorrelations) {
                            WAITING.this.initializeCorrelation(WAITING.this._scopeFrame.resolve(correlationSet), WAITING.this._scopeFrame.resolve(onMessage.variable));
                        }
                        if (onMessage.partnerLink.hasPartnerRole()) {
                            String string2;
                            Node node;
                            if (!(WAITING.this.getBpelRuntime().isPartnerRoleEndpointInitialized(WAITING.this._scopeFrame.resolve(onMessage.partnerLink)) && onMessage.partnerLink.initializePartnerRole || (node = WAITING.this.getBpelRuntime().getSourceEPR(string)) == null)) {
                                if (__log.isDebugEnabled()) {
                                    __log.debug((Object)("Received callback EPR " + DOMUtils.domToString((Node)node) + " saving it on partner link " + onMessage.partnerLink.getName()));
                                }
                                WAITING.this.getBpelRuntime().writeEndpointReference(WAITING.this._scopeFrame.resolve(onMessage.partnerLink), (Element)node);
                            }
                            if ((string2 = WAITING.this.getBpelRuntime().getSourceSessionId(string)) != null) {
                                WAITING.this.getBpelRuntime().initializePartnersSessionId(WAITING.this._scopeFrame.resolve(onMessage.partnerLink), string2);
                            }
                        }
                    }
                    catch (FaultException faultException) {
                        __log.error((Object)faultException);
                        FaultData faultData = WAITING.this.createFault(faultException.getQName(), onMessage);
                        PICK.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                        PICK.this.dpe(onMessage.activity);
                        return;
                    }
                    ActivityInfo activityInfo = new ActivityInfo(WAITING.this.genMonotonic(), onMessage.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(activityInfo, WAITING.this._scopeFrame, PICK.this._linkFrame));
                }

                public void onTimeout() {
                    for (OPickReceive.OnMessage onMessage : ((PICK)PICK.this)._opick.onMessages) {
                        PICK.this.dpe(onMessage.activity);
                    }
                    ActivityInfo activityInfo = new ActivityInfo(WAITING.this.genMonotonic(), ((PICK)PICK.this)._alarm.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(activityInfo, WAITING.this._scopeFrame, PICK.this._linkFrame));
                }

                public void onCancel() {
                    PICK.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(PICK.this._self.self){
                private static final long serialVersionUID = 4399496341785922396L;

                public void terminate() {
                    WAITING.this.getBpelRuntime().cancel(WAITING.this._pickResponseChannel);
                    1.instance((JacobRunnable)WAITING.this);
                }
            }));
        }
    }
}

