/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.IntrospectionException;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.MeasureUnit;
import org.eclipse.smila.management.RegistrationException;
import org.eclipse.smila.management.jmx.AgentMBean;
import org.eclipse.smila.management.performance.PerformanceCounter;

class DynamicMBeanBuilder {
    private static final int NUMBER_3 = 3;
    private final Log _log = LogFactory.getLog(DynamicMBeanBuilder.class);
    private final ObjectName _objectName;
    private final String _beanName;
    private final ManagementAgent _bean;
    private final Method[] _methods;
    private final String[] _skippedMethodNames = new String[]{"hashCode", "getClass", "wait", "equals", "notify", "notifyAll", "toString", "getLocation", "setLocation", "getCategory", "getName"};
    private final Set<String> _skippedMethodsSet = new HashSet<String>();

    public DynamicMBeanBuilder(ObjectName objectName, ManagementAgentLocation location, ManagementAgent bean) throws RegistrationException {
        if (bean == null) {
            throw new RegistrationException("Bean is null!");
        }
        this._objectName = objectName;
        this._beanName = location.getName();
        this._bean = bean;
        this._methods = bean.getClass().getMethods();
        if (this._methods.length == 0) {
            throw new RegistrationException("Unable to find managed methods in class " + bean.getClass().getName());
        }
        String[] stringArray = this._skippedMethodNames;
        int n = this._skippedMethodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            this._skippedMethodsSet.add(methodName);
            ++n2;
        }
    }

    public Object build() throws RegistrationException {
        try {
            ModelMBeanInfo dMBeanInfo = this.buildModelMBeanInfo();
            AgentMBean mBean = new AgentMBean(dMBeanInfo, this._bean);
            return mBean;
        }
        catch (Throwable e) {
            throw new RegistrationException(e);
        }
    }

    private ModelMBeanInfo buildModelMBeanInfo() throws IllegalAccessException, InvocationTargetException {
        ArrayList<ModelMBeanOperationInfo> operationsList = new ArrayList<ModelMBeanOperationInfo>();
        ArrayList<ModelMBeanAttributeInfo> attributesList = new ArrayList<ModelMBeanAttributeInfo>();
        ModelMBeanConstructorInfo[] dConstructors = new ModelMBeanConstructorInfo[]{};
        ModelMBeanNotificationInfo[] dNotifications = new ModelMBeanNotificationInfo[]{};
        Method[] methodArray = this._methods;
        int n = this._methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!this._skippedMethodsSet.contains(method.getName())) {
                if (method.getParameterTypes().length == 0 && method.getName().startsWith("get") && !method.getName().equals("get") && method.getReturnType() != Void.TYPE) {
                    String attributeName = method.getName().substring(3);
                    boolean isPoc = PerformanceCounter.class.isAssignableFrom(method.getReturnType());
                    String measureUnitStr = null;
                    if (method.isAnnotationPresent(MeasureUnit.class)) {
                        measureUnitStr = method.getAnnotation(MeasureUnit.class).value();
                    }
                    Method setter = null;
                    Class<?> setterSignatureClass = null;
                    Method[] methodArray2 = this._methods;
                    int n3 = this._methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method method1 = methodArray2[n4];
                        if (method1.getParameterTypes().length == 1 && method1.getName().startsWith("set") && method1.getName().substring(3).equals(attributeName)) {
                            setter = method1;
                            setterSignatureClass = method1.getParameterTypes()[0];
                            break;
                        }
                        ++n4;
                    }
                    if (measureUnitStr != null) {
                        attributeName = String.valueOf(attributeName) + " (" + measureUnitStr + ") ";
                    }
                    DescriptorSupport attributeDescriptor = setter != null ? new DescriptorSupport("name=" + attributeName, "descriptorType=attribute", "getMethod=" + method.getName(), "setMethod=" + setter.getName(), "setterSignatureClass=" + setterSignatureClass.getName()) : (isPoc ? new DescriptorSupport("name=" + attributeName, "descriptorType=attribute", "getMethod=" + method.getName()) : new DescriptorSupport("name=" + attributeName, "descriptorType=attribute", "getMethod=" + method.getName()));
                    try {
                        ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(attributeName, attributeName, method, setter, attributeDescriptor);
                        attributesList.add(info);
                    }
                    catch (IntrospectionException exception) {
                        this._log.error((Object)("Error creating MBeanAttributeInfo [" + attributeName + "]"), (Throwable)exception);
                    }
                }
                ModelMBeanOperationInfo info = new ModelMBeanOperationInfo("", method);
                operationsList.add(info);
            }
            ++n2;
        }
        ModelMBeanOperationInfo[] dOperations = operationsList.toArray(new ModelMBeanOperationInfo[operationsList.size()]);
        ModelMBeanAttributeInfo[] dAttributes = attributesList.toArray(new ModelMBeanAttributeInfo[attributesList.size()]);
        DescriptorSupport beanDesc = new DescriptorSupport("name=" + this._objectName, "descriptorType=mbean", "displayName=" + this._beanName);
        ModelMBeanInfoSupport dMBeanInfo = new ModelMBeanInfoSupport(this._beanName, "", dAttributes, dConstructors, dOperations, dNotifications, (Descriptor)beanDesc);
        return dMBeanInfo;
    }
}

