/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.tika.internal;

import java.io.Writer;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PageBreakWriteOutContentHandler
extends WriteOutContentHandler {
    public static final String PAGEBREAK = "<pagebreak/>";
    private static final char[] PAGEBREAK_CHARS = "<pagebreak/>".toCharArray();
    private boolean isFirstPageBreak = true;

    public PageBreakWriteOutContentHandler(ContentHandler handler, int writeLimit) {
        super(handler, writeLimit);
    }

    public PageBreakWriteOutContentHandler(Writer writer, int writeLimit) {
        this((ContentHandler)new ToTextContentHandler(writer), writeLimit);
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            if ("div".equals(name) && atts != null && "page".equals(atts.getValue("class"))) {
                if (this.isFirstPageBreak) {
                    this.isFirstPageBreak = false;
                } else {
                    super.characters(PAGEBREAK_CHARS, 0, PAGEBREAK_CHARS.length);
                }
            }
            super.startElement(uri, localName, name, atts);
        }
        catch (SAXException e) {
            this.handleException(e);
        }
    }
}

