/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompilationMessageBundle;

public class CommonCompilationMessages
extends CompilationMessageBundle {
    public CompilationMessage infCompilingProcess() {
        return this.formatCompilationMessage("Compiling BPEL process.", new Object[0]);
    }

    public CompilationMessage errBpelParseErr() {
        return this.formatCompilationMessage("Error parsing BPEL process: the BPEL is either malformed or is invalid.", new Object[0]);
    }

    public CompilationMessage errCompilationErrors(int n, String string) {
        return this.formatCompilationMessage("Compilation completed with {0} error(s):\n{1}", n, string);
    }

    public CompilationMessage errUndeclaredLink(String string) {
        return this.formatCompilationMessage("Attempt to reference undeclared link \"{0}\".", string);
    }

    public CompilationMessage errInvalidImport(String string) {
        return this.formatCompilationMessage("The import \"{0}\" is invalid/malformed. */", string);
    }

    public CompilationMessage errWsdlImportFailed(String string, String string2) {
        return this.formatCompilationMessage("Unable to import WSDL at URI \"{0}\"; WSDL fault code \"{1}\".", string, string2);
    }

    public CompilationMessage errWsdlImportNotFound(String string, String string2) {
        return this.formatCompilationMessage("The WSDL for namespace \"{0}\" could not be found in \"{1}\".", string, string2);
    }

    public CompilationMessage errWsdlParseError(String string, String string2, String string3) {
        return this.formatCompilationMessage("{1}: [{0}] {2}", string, string2, string3);
    }

    public CompilationMessage errUnknownImportType(String string) {
        return this.formatCompilationMessage("The import type \"{0}\" is unknown.", string);
    }

    public CompilationMessage errUnspecifiedImportType() {
        return this.formatCompilationMessage("Must specify an import type.", new Object[0]);
    }

    public CompilationMessage errMissingImportLocation() {
        return this.formatCompilationMessage("Missing import location.", new Object[0]);
    }

    public CompilationMessage errUndeclaredProperty(QName qName) {
        return this.formatCompilationMessage("Attempt to reference undeclared property \"{0}\".", qName);
    }

    public CompilationMessage errUndeclaredVariable(String string) {
        return this.formatCompilationMessage("Attempt to reference undeclared variable \"{0}\".", string);
    }

    public CompilationMessage errUndeclaredCorrelationSet(String string) {
        return this.formatCompilationMessage("Attempt to reference undeclared correlation set \"{0}\".", string);
    }

    public CompilationMessage errMessageVariableRequired(String string) {
        return this.formatCompilationMessage("Cannot use non-message variable \"{0}\" in this context (message variable is required).", string);
    }

    public CompilationMessage errPropertyDeclaredWithComplexType(QName qName, QName qName2) {
        return this.formatCompilationMessage("Attempt to declare property \"{0}\" with complex type \"{1}\".", qName, qName2);
    }

    public CompilationMessage errDuplicateLinkTarget(String string) {
        return this.formatCompilationMessage("Duplicate declaration of target for link \"{0}\".", string);
    }

    public CompilationMessage errDuplicateLinkSource(String string) {
        return this.formatCompilationMessage("Duplicate declaration of source for link \"{0}\".", string);
    }

    public CompilationMessage errDuplicatePartnerLinkDecl(String string) {
        return this.formatCompilationMessage("Duplicate declaration of partnerLink \"{0}\".", string);
    }

    public CompilationMessage errVariableDeclMissingType(String string) {
        return this.formatCompilationMessage("Declaration of variable \"{0}\" does not specify the required type (either MessageType or ElementType).", string);
    }

    public CompilationMessage errVariableDeclInvalid(String string) {
        return this.formatCompilationMessage("Declaration of variable \"{0}\" specifies  both a MessageType and an ElementType.", string);
    }

    public CompilationMessage errVariableDeclMutipleTypes(String string) {
        return this.formatCompilationMessage("Declaration of variable \"{0}\" can specify either MessageType or ElementType, but not both.", string);
    }

    public CompilationMessage errDuplicateVariableDecl(String string) {
        return this.formatCompilationMessage("Duplicate declaration of variable \"{0}\".", string);
    }

    public CompilationMessage errUnknownActivity(String string) {
        return this.formatCompilationMessage("The BOM activity class \"{0}\" is unrecoginized.", string);
    }

    public CompilationMessage errNoRootActivity() {
        return this.formatCompilationMessage("Process has no root activity.", new Object[0]);
    }

    public CompilationMessage errUnknownExpressionLanguage(String string) {
        return this.formatCompilationMessage("The expression language \"{0}\" is unrecognized.", string);
    }

    public CompilationMessage errNoWsdlDefinitionForNamespace(String string) {
        return this.formatCompilationMessage("No WSDL definition for namespace \"{0}\".", string);
    }

    public CompilationMessage errUndeclaredMessage(String string, String string2) {
        return this.formatCompilationMessage("Attempt to reference undeclared WSDL message \"{0}\" in namespace {1}.", string, string2);
    }

    public CompilationMessage errAliasUndeclaredMessage(QName qName, String string) {
        return this.formatCompilationMessage("Missing message type reference in property alias for property {0} using path {1}.", qName.toString(), string);
    }

    public CompilationMessage errUndeclaredPropertyAlias(String string, QName qName) {
        return this.formatCompilationMessage("The property \"{1}\" does not have an alias for message type \"{0}\".", string, qName);
    }

    public CompilationMessage errUndeclaredPartnerLink(String string) {
        return this.formatCompilationMessage("Attempt to reference undeclared partner link \"{0}\".", string);
    }

    public CompilationMessage errUndeclaredPartnerLinkType(QName qName) {
        return this.formatCompilationMessage("Attempt to reference undeclared partner link type \"{0}\".", qName);
    }

    public CompilationMessage errUndeclaredRole(String string, QName qName) {
        return this.formatCompilationMessage("Attempt to reference undeclared role \"{0}\" for partnerLink \"{1}\".", string, qName);
    }

    public CompilationMessage errUndeclaredPortType(QName qName) {
        return this.formatCompilationMessage("Attempt to reference undeclared portType \"{0}\".", qName);
    }

    public CompilationMessage errUndeclaredMessagePart(String string, QName qName, String string2) {
        return this.formatCompilationMessage("Attempt to reference undeclared part \"{2}\" for variable \"{0}\": the WSDL message type \"{1}\" does not declare \"{2}\".", string, qName, string2);
    }

    public CompilationMessage errPartnerLinkDoesNotDeclareMyRole(String string) {
        return this.formatCompilationMessage("The partnerLink \"{0}\" does not define a myRole.", string);
    }

    public CompilationMessage errPartnerLinkDoesNotDeclarePartnerRole(String string) {
        return this.formatCompilationMessage("The partnerLink \"{0}\" does not define a partnerRole.", string);
    }

    public CompilationMessage errPartnerLinkNoPartnerRoleButInitialize(String string) {
        return this.formatCompilationMessage("The partnerLink \"{0}\" does not define a partnerRole but is set to initializePartnerRole=yes.", string);
    }

    public CompilationMessage errUndeclaredOperation(QName qName, String string) {
        return this.formatCompilationMessage("The operation \"{1}\" is not declared on portType \"{0}\".", qName, string);
    }

    public CompilationMessage errVariableTypeMismatch(String string, QName qName, QName qName2) {
        return this.formatCompilationMessage("The variable \"{0}\" must be of type \"{1}\" to be used in this context; its actual type is \"{2}\".", string, qName, qName2);
    }

    public CompilationMessage errPortTypeMismatch(QName qName, QName qName2) {
        return this.formatCompilationMessage("The port type \"{0}\" does not match the expected port type (\"{1}\").", qName, qName2);
    }

    public CompilationMessage errUseOfUninitializedCorrelationSet(String string) {
        return this.formatCompilationMessage("Attempt to use correlation set \"{0}\" before it has been initialized.", string);
    }

    public CompilationMessage errTwoWayOperationExpected(String string) {
        return this.formatCompilationMessage("Attempt to use one-way operation \"{0}\" in a context requiring a request-response.", new Object[0]);
    }

    public CompilationMessage errMissingQueryExpression() {
        return this.formatCompilationMessage("A required query language expression was not present.", new Object[0]);
    }

    public CompilationMessage errCompensateNAtoContext() {
        return this.formatCompilationMessage("Compensation is not applicable in this (non-recovery) context.", new Object[0]);
    }

    public CompilationMessage errCompensateOfInvalidScope(String string) {
        return this.formatCompilationMessage("The scope \"{0}\" is not available for compensation in this context.", string);
    }

    public CompilationMessage errUnrecognizedBpelVersion() {
        return this.formatCompilationMessage("Unrecognized BPEL version!", new Object[0]);
    }

    public CompilationMessage errUndeclaredXsdType(QName qName) {
        return this.formatCompilationMessage("Attempt to reference undeclared XSD type \"{0}\".", qName);
    }

    public CompilationMessage errUnrecognizedVariableDeclaration(String string) {
        return this.formatCompilationMessage("The declaration of variable \"{0}\" was not recognized.", string);
    }

    public CompilationMessage errTODO(String string) {
        return this.formatCompilationMessage("FEATURE NOT SUPPORTED: {0}", new Object[0]);
    }

    public CompilationMessage errBpel11RequiresWsdl() {
        return this.formatCompilationMessage("A WSDL document must be specified for a BPEL4WS 1.1 process.", new Object[0]);
    }

    public CompilationMessage errLinkCrossesEventHandlerBoundary(String string) {
        return this.formatCompilationMessage("The link \"{0}\" crosses an event handler boundary.", new Object[0]);
    }

    public CompilationMessage errInvalidAlarm() {
        return this.formatCompilationMessage("Invalid alarm handler (check for/until/repeatEvery or child activity).", new Object[0]);
    }

    public CompilationMessage errInvalidEvent() {
        return this.formatCompilationMessage("Invalid event handler (no child activity?).", new Object[0]);
    }

    public CompilationMessage warnWsdlUriIgnoredFor20Process() {
        return this.formatCompilationMessage("Process WSDL URI is ignored for WS-BPEL 2.0 processes.", new Object[0]);
    }

    public CompilationMessage errDuplicateWSDLImport(String string, String string2) {
        return this.formatCompilationMessage("Attempted to import WSDL for namespace {0} from multiple locations: definitions from {1} will be ignored!", string, string2);
    }

    public CompilationMessage errSchemaError(String string) {
        return this.formatCompilationMessage("Error in schema processing: {0}", string);
    }

    public CompilationMessage errInvalidDocXsltUri(String string) {
        return this.formatCompilationMessage("XSLT stylesheet URI is invalid/malformed: {0}", string);
    }

    public CompilationMessage errCantFindXslt(String string) {
        return this.formatCompilationMessage("Could not find the XSLT stylesheet referenced with URI {0}, make sure it has been properly provided to the compiler.", string);
    }

    public CompilationMessage errNoMyRoleOnReceivePartnerLink(String string) {
        return this.formatCompilationMessage("Partner link {0} used in receive activity doesn't define role myRole.", string);
    }

    public CompilationMessage errInvalidDeploymentDescriptor(String string) {
        return this.formatCompilationMessage("Deployment descriptor is invalid: {0}", string);
    }

    public CompilationMessage errInvalidRetryForValue(String string) {
        return this.formatCompilationMessage("The retryFor attribute must be a positive integer, found {0}", string);
    }

    public CompilationMessage errInvalidRetryDelayValue(String string) {
        return this.formatCompilationMessage("The retryDelay attribute must be a positive integer, found {0}", string);
    }

    public CompilationMessage errAtomicScopeNesting(boolean bl) {
        if (bl) {
            return this.formatCompilationMessage("Cannot nest atomic scopes inside each other.", new Object[0]);
        }
        return this.formatCompilationMessage("A scope enclosed inside an atomic scope cannot declare itself as not atomic", new Object[0]);
    }

    public CompilationMessage errIsolatedScopeNesting() {
        return this.formatCompilationMessage("Cannot nest isolated scopes.", new Object[0]);
    }

    public CompilationMessage errProcessNameNotSpecified() {
        return this.formatCompilationMessage("The process name was not specified.", new Object[0]);
    }

    public CompilationMessage errProcessNamespaceNotSpecified() {
        return this.formatCompilationMessage("The process namespace was not specified.", new Object[0]);
    }

    public CompilationMessage errMissingMyRolePortType(QName qName, String string, QName qName2) {
        return this.formatCompilationMessage("Missing portType {0} on partnerLinkType {1} for myRole {2}", qName, qName2, string);
    }

    public CompilationMessage errMissingPartnerRolePortType(QName qName, String string, QName qName2) {
        return this.formatCompilationMessage("Missing portType {0} on partnerLinkType {1} for partnerRole {2}", qName, qName2, string);
    }

    public CompilationMessage errUnknownPartInAlias(String string, String string2) {
        return this.formatCompilationMessage("The part {0} declared in property alias for messageType {1} couldn't be found.", string, string2);
    }

    public CompilationMessage errEmptyScope() {
        return this.formatCompilationMessage("Empty scopes are forbidden.", new Object[0]);
    }

    public CompilationMessage errEmptySequence() {
        return this.formatCompilationMessage("Empty sequences are forbidden.", new Object[0]);
    }

    public CompilationMessage errMustSpecifyRelatedVariable(String string) {
        return this.formatCompilationMessage("The external variable declaration for \"{0}\" must specify a related variable.", string);
    }

    public CompilationMessage errMustSpecifyExternalVariableId(String string) {
        return this.formatCompilationMessage("The external variable declaration for \"{0}\" must specify an external variable identifier.", string);
    }

    public CompilationMessage errEmptyCatch() {
        return this.formatCompilationMessage("Empty catch faut handlers are forbidden.", new Object[0]);
    }
}

