/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore.httphandler;

import java.util.Collection;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.URLCreator;

/**
 * Implements the handling of HTTP requests for listing stores.
 */
public class ObjectStoreServiceHandler extends AStoreHandler {

  /**
   * GET: list stores.
   */
  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method);
  }

  /**
   * build list of store names and URIs.
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord,
    final HttpExchange exchange) throws Exception {
    if ("GET".equals(method)) {
      final Collection<String> storeNames = getObjectStoreService().getStoreNames();
      final AnyMap result = FACTORY.createAnyMap();
      final AnySeq storeList = FACTORY.createAnySeq();
      result.put("stores", storeList);
      if (storeNames != null) {
        for (final String storeName : storeNames) {
          final AnyMap store = FACTORY.createAnyMap();
          store.put("store", storeName);
          store.put("url", URLCreator.create(getRequestHost(exchange), requestUri, storeName).toString());
          storeList.add(store);
        }
      }
      return result;
    }
    return null;
  }
}
